/***************************************************************************
begin                : Tue Aug 20 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPTABLE_H
#define IPTABLE_H

/**Class that represents the properties of a "table" in the iptables
 
  *@author Christian Hubinger
  */

#include "netfilterobject.h"

// qt includes
#include <qptrlist.h>

// project includes
#include "iptchain.h"

// project classes
class KMFError;
class KMFIPTDoc;
// qt classes
class QString;

class KDE_EXPORT IPTable : public NetfilterObject {
public:
	/** initialise a IPTable with the given name */
	IPTable( KMFIPTDoc*, const QString& name );
	~IPTable();

	/** Set the used flag */
	void setUsed( bool used ) {
		m_used = used;
	};

	/** Simply deletes all chains */
	void reset();

	/** Return the IPTChain with the name provided */
	IPTChain* chainForName( QString& );
	
	/** Return the IPTChain for the given ID */
	IPTChain* chainForID( int );

	/**  Add a new IPTChain object to this table with the given prperties */
	IPTChain* addChain( QString& chain_name,
	                    QString& chain_target,
	                    bool builtin,
	                    KMFError* );

	/** Remove the given IPTChain */
	KMFError* delChain( IPTChain *chain );


	/** Move rule to target_chain */
	KMFError* moveRuleToChain( IPTRule* rule, IPTChain *target_chain );

	/** Copy rule to target_chain */
	KMFError* copyRuleToChain( IPTRule* rule, IPTChain *target_chain );

	/** Return a pointer to KMFIPTDoc object to which this
		table belongs */
	KMFIPTDoc* kmfDoc() const {
		return kmfdoc;
	};


	/** Returns true if it used by the current configuration */
	bool used() const {
		return m_used;
	};

	/** Returns the list with the iptchains in this table */
	QPtrList<IPTChain>& chains() const;

	/** Return a QDomDocument representation of this Table */
	const QDomDocument& getDOMTree();
	
	/** Load the Table from the QDomDocument */
	void loadXML( const QDomDocument& );
	
	/** Stup the built-in chains */
	void settupDefaultChains();

private:
	/** the list holding the chains in this table */
	private: QPtrList<IPTChain> m_chains;

	/** used by the current configuration */
	private: bool m_used;


	private: KMFError* m_err;
	private: KMFIPTDoc* kmfdoc;
};

#endif


