/***************************************************************************
                       kmfruleeditortargetnat.h  -  description
                          -------------------
 begin                : Sun May 26 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDITORTARGETNAT_H
#define KMFRULEEDITORTARGETNAT_H

#include <qwidget.h>
#include <kmyfirewallruleeditortargetnat.h>

/**
  *@author Christian Hubinger
  */

class IPTRule;
class KMFCheckInput;
class KMFErrorHandler;
class KMFRuleEditorTargetNat : public KMyFirewallRuleEditorTargetNat {
	Q_OBJECT
public:
	KMFRuleEditorTargetNat( QWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFRuleEditorTargetNat();

	IPTRule* curr_rule;

	void loadRule( IPTRule *rule );
	void setMode( bool isSnat ) {
		mbsnat = isSnat;
	};

public slots:
	void accept();
	void reject();
	void slotHelp();

signals:
	void sigAddTargetOpt( QString *, QPtrList<QString> * );
	void sigDelTargetOpt( QString * );
	void sigDocumentChanged();
	void sigHideMe();
private:
	bool mbsnat;
	KMFCheckInput *m_CheckInput;
	KMFErrorHandler *m_ErrorHandler;

};

#endif
