/***************************************************************************
                          imchatservice.cpp  -  description
                             -------------------
    begin                : Tue Nov 27 2001
    copyright            : (C) 2001 by Olaf Lueg
    email                : olueg@olsd.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "imchatservice.h"
#include "imservice.h"
#include <time.h>
// qt
#include <qdatetime.h>
#include <qsocket.h>
#include <kextsock.h>
// kde
#include <klocale.h>
#include <kglobal.h>
#include <kdebug.h>

IMChatService::IMChatService()
{
	socketTimer = 0L;
}
IMChatService::~IMChatService(){
	
}

void IMChatService::connectToSwitchBoard(QString ID, QString address, QString auth){
	QString server,port,command;
	time_t Tr_ID = time((time_t *)NULL);
	if(ID == 0L)
	{
		command.sprintf("USR %lu ",Tr_ID);
		command += myHandle +" "+ auth+"\r\n";
		server = address;
		server = server.left(server.find(":"));
		port = address;
		port = port.right(port.length() -port.findRev(":")-1);
	}
	else
	{
		command.sprintf("ANS %lu ",Tr_ID);
		command += myHandle +" "+ auth + " "+ ID +"\r\n";
		server = address;
		server = server.left(server.find(":"));
		port = address;
		port = port.right(port.length() -port.findRev(":")-1);
	}
	msgSocket = new KExtendedSocket(server,port.toUInt(),0x00 | 0x600000 );
	msgSocket->enableRead(true);
	connect(msgSocket, SIGNAL(readyRead()),this, SLOT(slotDataReceived()));
//	connect(msgSocket, SIGNAL(connectionSuccess()),this, SLOT(slotReady()));
//	connect(msgSocket, SIGNAL(connectionFailed(int)), this, SLOT(slotSocketError(int)));
	msgSocket->connect();
	msgSocket->writeBlock(command,command.length());
	// send active message
	emit switchBoardIsActive(true);
	/** FIXME : we have no socketClosed signal */
	if( socketTimer != 0L)
		killTimer(socketTimer);
	socketTimer = startTimer(1000);
}

void IMChatService::timerEvent(QTimerEvent *ev)
{
	if(ev->timerId() == socketTimer )
	{
		if(msgSocket->socketStatus() != KExtendedSocket::done )
		{
			emit switchBoardIsActive(true);
		}
		else
		{
			emit switchBoardIsActive(false);
			killTimer(socketTimer);
			socketTimer = 0L;
//			delete msgSocket;
			kdDebug() << "connection lost: " << msgSocket->socketStatus() << endl;
		}
	}
}

/* reads a line from the buffer */
QString IMChatService::readLine()
{
	QString command;
	int index = buffer.find("\r\n");
	if(index != -1 )
	{
		command = buffer.left(index );
		buffer = buffer.remove(0,index+2 );
		command.replace(QRegExp("\r\n"),"");
	}
	return command;
}

/* check if a new line is in the buffer */
bool IMChatService::canReadLine()
{
	if(buffer.contains("\r\n") )
		return true;
	return false;
}

/* reads a block of data from the buffer from  ( 0 to len ) */
QString IMChatService::readBlock(uint len)
{
	QString block;
	block = buffer.left(len);
	buffer = buffer.remove(0,len);
	return block;
}
void IMChatService::slotDataReceived()
{
	QString str,len,miss, data; char dat[1024];
	int ret;
	ret = msgSocket->readBlock(dat,1024);
	if(ret <= 0) return;
	data = dat;
	data = data.left(ret);
	data = QString::fromUtf8(data);
	buffer += data;
redo:
	if(canReadLine())
	{
		str = readLine();
//		str = QString::fromUtf8(dat);
		if(str.left(3) == "NAK")
		{
			emit msgAcknowledgement(false);    // msg has not reveived
		}
		if(str.left(3) == "ACK")
		{
			emit msgAcknowledgement(true);   // msg has received
		}
		if(str.left(3) == "JOI")
		{
			// new user joins the chat, update user in chat list
			emit switchBoardIsActive(true);
			emit updateChatMember(kstr.word(str,1),"JOI",false);
		}
		if(str.left(3) == "IRO")
		{
			// we have joined a multi chat session- this are the users in this chat
			emit switchBoardIsActive(true);
			if(kstr.word(str,2) == kstr.word(str,3) )
			{
				emit updateChatMember(kstr.word(str,4),"IRO",true);
			}
			else
			{
				emit updateChatMember(kstr.word(str,4),"IRO",false);
			}
		}
		if(str.left(3) == "USR")
		{
			callUser();
		}
		if(str.left(3) == "BYE")
		{
			// some has disconnect from chat, update user in chat list
			emit updateChatMember(kstr.word(str,1).replace(QRegExp("\r\n"),""),"BYE",false);
		}
	if(str.left(3) == "MSG")
	{
		len = kstr.word(str,3);
		miss = readBlock(len.toUInt());
		miss = miss.left(len.toUInt());
		if(miss.contains("Content-Type: text/plain;"))
		{
			miss = miss.right(miss.length() -miss.findRev("\r\n\r\n"));
			QString handle = kstr.word(str,1);
			emit msgReceived(handle,imService->getPublicName(handle), miss);//.replace(QRegExp("\r\n"),""));
		}
	// incoming message for File-transfer
		if(miss.contains("Content-Type: text/x-msmsgsinvite; charset=UTF-8"))
		{
		// filetransfer ,this comes in a later release
			// needs some debugging time
			kdDebug() << "filetransfer : " << miss << endl;
			if(miss.contains("Invitation-Command: ACCEPT"))
			{
			 	//fileSocket = new QSocket(this);
				//connect(fileSocket,SIGNAL(readyRead()),this,SLOT(slotFileData()));
				//fileSocket->connectToHost("192.168.0.1",6891);
				//kdDebug() << "socket erstellt" << endl;

			}
			else
			{
				QString cocki = miss.right(miss.length() - miss.find("Invitation-Cookie:")-19);
				cocki = cocki.left(cocki.find("\r\n"));
				debug("cocki"+cocki);
				time_t Tr_ID = time((time_t *)NULL);
				QString command, message = "MIME-Version: 1.0\r\nContent-Type: text/x-msmsgsinvite; charset=UTF-8\r\n\r\nInvitation-Command: ACCEPT\r\n";
				message += "Invitation-Cookie: "+cocki+"\r\nLaunch-Application: FALSE\r\nRequest-Data: IP-Address: 192.168.0.2\r\nPort: 6891"; //Application-Name: FileTransfer\r\nApplication-GUID: {5D3E02AB-6190-11d3-BBBB-00C04F795683}\r\nInvitation-Command: INVITE\r\nInvitation-Cookie: 58273\r\nApplication-File: lvback.gif\r\nApplication-FileSize: 4256\r\n\r\n";
				command.sprintf("MSG %lu N %d\r\n",Tr_ID,message.length());
				command += message;
				msgSocket->writeBlock(command,command.length());
				debug("gesendet : "+command);
			}
		}
		if(miss.contains("MIME-Version: 1.0\r\nContent-Type: text/x-msmsgscontrol\r\nTypingUser:"))
		{
			QString message;
			message = miss.right(miss.length() - miss.findRev(" ")-1);
			message = message.replace(QRegExp("\r\n"),"");
			emit userTypingMsg(message);    // changed 20.10.2001
		}
		}
	}
	if(canReadLine())goto redo;
}

// this sends the user is typing msg
void IMChatService::slotTypingMsg()
{
	time_t Tr_ID = time((time_t *)NULL);
	QString command, message = "MIME-Version: 1.0\r\nContent-Type: text/x-msmsgscontrol\r\nTypingUser: "+myHandle+"\r\n\r\n";
	command.sprintf("MSG %lu U %d \r\n",Tr_ID,message.length());
	command += message;
	msgSocket->writeBlock(command,command.length());
}

// this Invites an Contact
void IMChatService::slotInviteContact(QString handle)
{
	time_t Tr_ID = time((time_t *)NULL);
	QString command;
	command.sprintf("CAL %lu ",Tr_ID);
	command += handle+"\r\n";
	msgSocket->writeBlock(command,command.length());
}

// this sends a short message to the server
void IMChatService::slotSendMsg(QString message)
{
	time_t Tr_ID = time((time_t *)NULL);
	QString command,head;
	head ="MIME-Version: 1.0\r\nContent-Type: text/plain; charset=UTF-8\r\nX-MMS-IM-Format: FN=MS%20Sans%20Serif; EF=; CO=0; CS=0; PF=0\r\n\r\n";
	head += message.utf8();
	command.sprintf("MSG %lu A %d\r\n",Tr_ID,head.length());
	command += head;
	msgSocket->writeBlock(command,command.length());
	emit msgReceived(myHandle, imService->getPublicName(), message);    // send the own msg to chat window
}

void IMChatService::slotSocketClosed()
{
	// we have lost the connection, send a message to chatwindow (this will not displayed)
	emit switchBoardIsActive(false);
	delete this;
}

void IMChatService::slotCloseSession()
{
	QString command = "OUT\r\n";
	msgSocket->writeBlock(command,command.length());
}

void IMChatService::callUser()
{
	time_t Tr_ID = time((time_t *)NULL);
	QString command;
	command.sprintf("CAL %lu ",Tr_ID);
	command += msgHandle+"\r\n";
	msgSocket->writeBlock(command,command.length());
}

