/***************************************************************************
                           krootcontainer.cpp - 
                         ---------------------------
    begin                : Wed Feb 14 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "krootcontainerimpl.h"
#include "krootcontainer.h"


KRootContainer::KRootContainer(KRootContainerImpl *impl) : KContainer(impl) 
{
}

KRootContainerImpl * KRootContainer::impl() const 
{
   return dynamic_cast<KRootContainerImpl*>(KObject::impl());
}

KObject KRootContainer::findDefault(int type) const 
{
   return KObject(impl()->findDefault(type));
}

QString KRootContainer::fileName() const 
{
   return impl()->fileName();
}

bool KRootContainer::save(const QString &filename) const
{
   return impl()->save(filename);
}

int KRootContainer::itemCountGlobal() const
{
   return impl()->itemCountGlobal();
}

int KRootContainer::itemActiveCountGlobal() const
{
   return impl()->itemActiveCountGlobal();
}

bool KRootContainer::isModified() const 
{
   return impl()->isModified();
}
   
void KRootContainer::setModified() const
{
   impl()->setModified();
}

void KRootContainer::resetModified() const
{
   impl()->resetModified();
}

void KRootContainer::setCallback(KNotifyChange *cb) const
{
   impl()->setCallback(cb);
}

/* Local Variables: */
/* mode: c++ */
/* End: */
