/***************************************************************************
                          kmagodoc.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.29 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfileinfo.h>
#include <qwidget.h>
#include <qmultilineedit.h>
#include <qtextstream.h>
#include <kmessagebox.h>
#include <kapp.h>
#include <kdebug.h>
#include <klocale.h>
#include <knotifyclient.h>
#include "utils.h"
#include "kcntiterator.h"
#include "kmago.h"
#include "kmagoview.h"
#include "kcontainerview.h"
#include "kdlgopentransfer.h"
#include "ksystrayview.h"
#include "kmagodoc.h"


KMagoBugReport::KMagoBugReport(QWidget * parent, bool modal,
			       const KAboutData *aboutData)
   : KBugReport(parent, modal, aboutData)
{
}

void KMagoBugReport::appendLine(const QString &line)
{
   m_lineedit->insertLine(line);
}

/////////////////////////////////////////////////////////////////

void KMagoDoc::NotifyChange::operator()(const KObject obj) const
{
   kdFatal(_doc->isClosed(), D_RUN) << _doc->name() << ": notify on closed doc" << endl;
   //_doc->mainView()->updateView(obj);
   KApplication::postEvent(_doc, new DocEvent(obj));
   // signal for status and log windows
   if (!obj.toTransfer().isNull())
      emit _doc->sigTransferChange(obj.toTransfer());
}

/////////////////////////////////////////////////////////////////

KMagoDoc::KMagoDoc(KMagoApp *parent, const char *name)
   : QObject(parent, name),
     _app(parent), _title(i18n("Untitled")),
     _tmp(false), _exitOnIdle(false), _firstIdle(true),
     _executeOnIdle(false)
{
   KObject::initFactory();
   connect(&_timerUpd, SIGNAL(timeout()), SLOT(slotUpdate()));
   connect(&_timerSave, SIGNAL(timeout()), SLOT(slotSave()));
   connect(&_timerTStart, SIGNAL(timeout()), SLOT(slotTransferStart()));
   _curTransferDict.setAutoDelete(true);
}

KMagoDoc::~KMagoDoc()
{
   kdDebug(D_INI) << name() << " destroy" << endl;
   if (!isClosed())
      close();
   //KObject::deleteFactory(); FIXME find a place to call this
}

KMagoApp * KMagoDoc::mainView() const
{
   return _app;
}

KMainWindow * KMagoDoc::mainWindow() const
{
   return _app;
}

KMagoView * KMagoDoc::view() const
{
   return mainView()->view(); //FIXME!!
}

bool KMagoDoc::openNew()
{
   QString filename = tempFile();
   return open(filename, true);
}

bool KMagoDoc::openLastUsed()
{
   kdDebug(D_INI) << name() << ": open last used doc " << _lastUsed << endl;
   if (_lastUsed.isEmpty())
      return openNew();
   return open(_lastUsed);
}

bool KMagoDoc::open(const QString &filename, bool tmpDoc)
{
   kdDebug(D_INI) << name() << (tmpDoc ? ": new doc " : ": open doc ") << filename << endl;
   if (!isClosed())
      close();
   _manager = KMManager::managerLoad(filename, true, new NotifyChange(this));
   if (manager().isNull())
      return false;
   _tmp = tmpDoc;
   if (tmpDoc)
   {
      setTitle(i18n("Temporary"));
   }
   else
   {
      setTitle(QFileInfo(filename).fileName());
      mainView()->fileOpenRecent->addURL(filename);
      _lastUsed = filename;
   }
   if (manager().isEmpty())
      manager().itemNew(i18n("default"));
   resetView();
   return true;
}

bool KMagoDoc::saveAs(const QString &f)
{
   QFileInfo fileInfo(f);
   QString filename = fileInfo.absFilePath();
   QString oldfile = manager().fileName();
   if (filename.isEmpty() || filename == manager().fileName())
      return false;
   //QFile f(fileInfo.absFilePath());
   if (manager().save(filename))
   {
      if (isTmp())
	 QDir::current().remove(oldfile);
      setTitle(fileInfo.fileName());
      mainView()->fileOpenRecent->addURL(filename);
      _lastUsed = filename;
      _tmp = false;
      resetView(); //FIXME to update caption
      return true;
   }
   return false;
}

void KMagoDoc::close()
{
   kdDebug(D_INI) << name() << ": close doc" << endl;
   if (isClosed())
      return;

   QString oldfile = manager().fileName();
   setCurrentManager(KTManager::null());
   view()->managerView()->clear();
   view()->transferView()->clear();

   manager().setCallback(0);
   manager().kill(true);
   if (manager().isModified())
      manager().save();
   _manager.deleteInstance();
   _title = "Untitled";

   if (isTmp())
      QDir::current().remove(oldfile);
}

void KMagoDoc::start()
{
   _timerUpd.start(_cfg_updateTime, false);
   _timerTStart.start(_cfg_TStartTime, false);
   _timerSave.start(_cfg_saveTime*1000, false);
}

void KMagoDoc::saveConfig(KConfig *config)
{
   kdDebug(D_INI) << name() << ": save config" << endl;
   config->writeEntry("Open Flags", _cfg_openFlags);
   config->writeEntry("Update Time", _cfg_updateTime);
   config->writeEntry("Save Time", _cfg_saveTime);
   config->writeEntry("Transfer Start Time", _cfg_TStartTime);
   config->writeEntry("Expert Mode", _cfg_expertMode);
   //config->writeEntry("ExitOnIdle", _cfg_exitOnIdle);
   config->writeEntry("Load Last Doc", _cfg_loadLastDoc);
   config->writeEntry("List On Drop", _cfg_listOnDrop);
   config->writeEntry("EnableNotify", _cfg_enableNotify);
   config->writeEntry("AutoProgress", _cfg_autoProgress);
   config->writeEntry("TrayProgress", _cfg_trayProgress);
   config->writeEntry("CommandOnIdle", _cfg_commandOnIdle);
   if (!_lastUsed.isEmpty())
      config->writeEntry("Last Used Document", _lastUsed);
   if (!isSingleDoc())
      mainView()->fileOpenRecent->saveEntries(config, "Recent Files");
   mainView()->managerAddRecent->saveEntries(config, "Recent Transfers");
}

void KMagoDoc::readConfig(KConfig* config)
{
   kdDebug(D_INI) << name() << ": read config" << endl;
   _cfg_openFlags = config->readNumEntry("Open Flags",
					 FLG_PROMPT | FLG_START_PROMPT);
   _cfg_expertMode = config->readBoolEntry("Expert Mode", false);
   //_cfg_exitOnIdle = false; //config->readBoolEntry("ExitOnIdle", false);
   _cfg_updateTime = config->readNumEntry("Update Time", 2000);
   _cfg_saveTime = config->readNumEntry("Save Time", 10);
   _cfg_TStartTime = config->readNumEntry("Transfer Start Time", 2000);
   _cfg_loadLastDoc = config->readBoolEntry("Load Last Doc", true);
   _cfg_listOnDrop = config->readBoolEntry("List On Drop", false);
   _lastUsed = config->readEntry("Last Used Document", "");
   _cfg_enableNotify = config->readBoolEntry("EnableNotify", true);
   _cfg_autoProgress = config->readBoolEntry("AutoProgress", false);
   _cfg_trayProgress = config->readBoolEntry("TrayProgress", false);
   _cfg_commandOnIdle = config->readEntry("CommandOnIdle", "");
   if (!isSingleDoc())
      mainView()->fileOpenRecent->loadEntries(config, "Recent Files");
   mainView()->managerAddRecent->loadEntries(config, "Recent Transfers");
}

void KMagoDoc::loadState(bool restored)
{
   kdDebug(D_INI) << name() << ": loadState " << restored << endl;
   KConfig * config = kapp->config();
   QString grp = config->group();
   config->setGroup("Configuration");
   readConfig(config);
   // if this window is not being restored
   if (!restored)
   {
      mainView()->applySettings(config, false);
      view()->initView();
   }
   config->setGroup(grp);
}

void KMagoDoc::saveState()
{
   KConfig * config = kapp->config();
   QString grp = config->group();
   config->setGroup("Configuration");
   saveConfig(config);
   //config->sync();
   config->setGroup(grp);
}

void KMagoDoc::reloadState()
{

   for (QListIterator<KMainWindow> it(*KMainWindow::memberList); it.current();
	++it)
   {
      dynamic_cast<KMagoApp*>(it.current())->doc()->loadState(true);//FIXME so to not reapply window settings??
   }
}

int KMagoDoc::isDuplicate(const KURL &rmt, const KURL &lcl)
{
   for (KCntIterator itm(manager()); !itm.current().isNull(); ++itm)
   {
      KTManager m = itm.current().toTManager();
      for (KCntIterator itt(m); !itt.current().isNull(); ++itt)
      {
	 KTransfer t = itt.current().toTransfer();
	 if (t.remote() == rmt)
	    return 1;
	 if (t.local().path() == lcl.path())
	    return 2;
      }
   }
   return 0;
}

void KMagoDoc::addTransfer(const KURL &u, KTManager mngr, int mode)
{
   if (mngr.isNull())
      mngr = currentManager();
   if (mode == FLG_DEFAULT)
      mode = getOpenFlags();
   int type = mngr.getDefaultType();
   KURL rmt = u;
   KURL lcl;
   lcl.setPath(QFileInfo(mngr.getDownloadDir(), rmt.fileName()).absFilePath());
   if (mode & (FLG_FILE_AUTO_ENCODE | FLG_FILE_FORCE_ENCODE))
      lcl.setFileName(encodeFileName(lcl.fileName()));

   if ((rmt.path().isEmpty() || (mode & FLG_PROMPT))
       && !KDlgOpenTransfer::getOpenTransfer(this, mngr, rmt, lcl, type))
      return;
   KTransfer glb = mngr.findGlobal(type).toTransfer();
   if (glb.isNull())
   {
      KMessageBox::sorry(mainWindow(),
			 i18n("Transfer Type not acceptable"),
			 i18n("transfer type not acceptable"), false);
      return;
   }
   if (!glb.isProtocolSupported(rmt.protocol()))
   {
      KMessageBox::sorry(mainWindow(),
			 i18n("Protocol " + rmt.protocol() + " not supported"),
			 i18n("protocol not supported"), false);
      return;
   }
   if (lcl.path().isEmpty() || QFileInfo(lcl.path()).isDir())
   {
      KMessageBox::sorry(mainWindow(),
			 i18n("File " + lcl.path() + " not acceptable"),
			 i18n("File not acceptable"), false);
      return;
   }
   // check for a transfer with these file or url
   int chk = isDuplicate(rmt, lcl);
   if (chk)
      switch (chk)
      {
      case 1:
	 KMessageBox::sorry(mainWindow(),
			    i18n("Url " + rmt.url() + " in use"),
			    i18n("Url in use"), false);
	 return;
      case 2:
	 KMessageBox::sorry(mainWindow(),
			    i18n("File " + lcl.path() + " in use"),
			    i18n("File in use"), false);
	 return;
      }
   // checking for file recover
   QString file, tmpfile;
   file = lcl.path();
   tmpfile = glb.getTempFile(rmt, lcl).path();
   if (QDir::current().exists(file))
   {
      if (QDir::current().exists(tmpfile) && file != tmpfile)
      {
	 // either tmpfile and file exists
	 switch (promptFilesToRecover(file, tmpfile))
	 {
	 case KMessageBox::Ok: // recover file
	    QDir::current().remove(tmpfile);
	    QDir::current().rename(file, tmpfile);
	    break;
	 case KMessageBox::Yes: // recover tmpfile
	    QDir::current().remove(file);
	    break;
	 case KMessageBox::No: // no recover
	    QDir::current().remove(file);
	    QDir::current().remove(tmpfile);
	    break;
	 case KMessageBox::Cancel:
	    return;
	 default: // cancel operation
	    kdFatal(D_RUN) << name() << ": addTransfer PROMPT ERROR" << endl;
	 } // end switch
      }
      else
      { // tmpfile not exists
	 // recover file
	 switch (promptFileToRecover(file))
	 {
	 case KMessageBox::Yes: // recover file
	    QDir::current().rename(file, tmpfile);
	    break;
	 case KMessageBox::No: // don't recover
	    QDir::current().remove(file);
	    break;
	 case KMessageBox::Cancel: // cancel operation
	    return;
	 default:
	    kdFatal(D_RUN) << name() << ": addTransfer PROMPT ERROR" << endl;
	 }
      } // end else
   }
   else
   { // file don't exists
      if (QDir::current().exists(tmpfile))
      {
	 // recover tmpfile
	 switch (promptFileToRecover(tmpfile))
	 {
	 case KMessageBox::Yes: // recover file
	    break;
	 case KMessageBox::No: // don't recover
	    QDir::current().remove(tmpfile);
	    break;
	 case KMessageBox::Cancel:
	    return;
	 default: // cancel operation
	    kdFatal(D_RUN) << name() << ": addTransfer PROMPT ERROR" << endl;
	 }
      }
   } // end else
   // evaluting start mode
   bool start = false;
   if (mode & FLG_START_PROMPT)
   {
      switch (promptStartMode(i18n("Select a start mode"),
			      i18n("Transfer:\n") + rmt.url() + i18n("\nto ") +
			      file))
      {
      case KMessageBox::Yes:
	 start = true;
	 break;
      case KMessageBox::No:
	 start = false;
	 break;
      case KMessageBox::Cancel:
	 return;
      default:
	 kdFatal(D_INI) << name() << ": addTransfer PROMPT ERROR" << endl;
      }
   }
   else
      start = (mode & FLG_START_NOW);
   // add transfer
   mainView()->managerAddRecent->addURL(rmt);
   KTransfer t = mngr.itemNew(type, rmt, lcl);
   if (start)
      t.start();
}

void KMagoDoc::setUpdateTime(int u)
{
   if (_cfg_updateTime != u)
   {
      _cfg_updateTime = u;
      _timerUpd.changeInterval(u);
   }
}

void KMagoDoc::setSaveTime(int u)
{
   if (_cfg_saveTime != u)
   {
      _cfg_saveTime = u;
      _timerSave.changeInterval(u*1000);
   }
}

void KMagoDoc::setTransferStartTime(int t)
{
   if (_cfg_TStartTime != t)
   {
      _cfg_TStartTime = t;
      _timerTStart.changeInterval(t);
   }
}

void KMagoDoc::setExitOnIdle(bool l)
{
   _exitOnIdle = l;
}

void KMagoDoc::setExecuteOnIdle(bool v)
{
   _executeOnIdle = v;
}

//////////////////////////////

void KMagoDoc::setCurrentManager(KTManager m)
{
   if (m == currentManager())
      return;
   _currentManager = m;
   if (m.isNull())
      return;
   mainView()->updateCaption();
   kdDebug(D_VIE) << name() << ": current manager " << m.id() << endl;
   // update current transfer
   // update main view
   mainView()->updateManagerMenu();
   mainView()->updateStatusBarCount();
   mainView()->updateStatusBarBand();
   // update view
   view()->managerView()->itemSelect(m);
   view()->transferView()->setContainer(m);
   KTransfer *t = _curTransferDict.find(m.id());
   if (t == 0 || t->isNull())
      setCurrentTransfer(view()->transferView()->itemFirst().toTransfer());
   else
      setCurrentTransfer(*t);
}

void KMagoDoc::setCurrentTransfer(KTransfer t)
{
   if (t == currentTransfer())
      return;
   _currentTransfer = t;
   kdDebug(D_VIE) << name() << ": current transfer " << (t.isNull() ? "NULL" : t.name()) << endl;
   // update main view
   if (!t.isNull())
   {
      mainView()->slotStatusMsg(t.remote().prettyURL() + " -> " + t.local().fileName());
      //slotDocTransferStateChange(t);
      KTransfer *i = _curTransferDict.find(t.container().id());
      if (i == 0)
      {
	 i = new KTransfer();
	 _curTransferDict.insert(t.container().id(), i);
      }
      *i = t;
   }
   else
   {
      mainView()->slotStatusMsg(i18n(KMagoApp::IDS_STATUS_DEFAULT));
   }
   // update view
   mainView()->updateTransferMenu();
   view()->transferView()->itemSelect(t);
}

void KMagoDoc::resetView()
{
   // reset object's mods
   for(KCntIterator it(manager()); !it.current().isNull(); ++it)
   {
      it.current().resetMods();
      for (KCntIterator itt(it.current().toTManager()); !itt.current().isNull();
	   ++itt)
	 itt.current().resetMods();
   }

   // reset current transfer dictionary
   _curTransferDict.clear();

   mainView()->setDownloadLock(manager().downloadLock());
   mainView()->updateManagerList();
   _currentManager.setNull();
   view()->reset();
   setCurrentManager(view()->managerView()->itemFirst().toTManager());
}

////////////////////////////////////////////////////////////////////////////

void KMagoDoc::updateView(KObject obj)
{
   if (obj.isNull())
   {
      kdWarning(D_VIE) << name() << ": updateView on null object" << endl;
      return;
   }
   kdDebug(D_VIE) << name() << ": mod obj " << obj.name() << " " << obj.modString() << endl;
   if (obj.isMod(MDI_MESSAGE))
      mainView()->slotStatusHelpMsg(obj.message());
   if (obj.isMod(MDI_FATAL))
   {
      // fatal error, open and fill bug report
      kdDebug(D_RUN) << name() << " catch fatal error of " << obj.name() << endl;
      KMagoBugReport *bugrep =
	 new KMagoBugReport(mainWindow(), false, kapp->aboutData());
      bugrep->appendLine(obj.message());
      bugrep->show();
   }
   if (!_firstIdle && (!manager().isIdle() || !executeOnIdle()))
      _firstIdle = true;
   switch (obj.type())
   {
   case TYP_MMANAGER:
      if (obj.isMod(MDI_MMN_IDLE))
      {
	 if (manager().isIdle() && executeOnIdle() && _firstIdle
	     && !getCommandOnIdle().isEmpty())
	 {
	    kdDebug(D_RUN) << name() << ": execute cmd on idle: " << getCommandOnIdle() << endl;
	    KShellProcess sh;
	    QStringList lst = QStringList::split(" ", getCommandOnIdle());
	    for (QStringList::Iterator it = lst.begin(); it != lst.end(); ++it)
	       sh << *it;
	    sh.start(KProcess::DontCare, KProcess::NoCommunication);
	    _firstIdle = false;
	 }

	 // if is idle and exitOnIdle is true, exit
	 if (exitOnIdle() && manager().isIdle())
	 {
	    if (getEnableNotify())
	       KNotifyClient::event("appQuit", i18n("Application quit"));
	    QTimer::singleShot(1000, mainView(), SLOT(slotFileClose()));
	 }
      }
      if (obj.isMod(MDI_MMN_DLOCK))
	 // changed lock download
	 ;
      if (obj.isMod(MDI_CNT))
      {
	 // added or removed a tmanager
	 mainView()->updateManagerList();
	 mainView()->managerRemoveMngr->setEnabled(manager().itemCount() > 1);
	 //updateManagerMenu();
	 //updateStatusBarBand();
	 mainView()->updateStatusBarCount();
	 mainView()->updateToolTip();
      }
      if (obj.isMod(MDI_ACTCNT))
      {
	 mainView()->killAll->setEnabled(manager().isRunning());
      }
      if ((obj.isMod(MDI_STOP) || obj.isMod(MDI_START)) && mainView()->sysTray())
	 mainView()->sysTray()->updateIcon();
      if (obj.isMod(MDI_BAND))
      {
	 // global band changed
	 mainView()->updateStatusBarBand();
	 mainView()->updateToolTip();
      }
      // others //FIXME??
      break;
   case TYP_TMANAGER:
      if (obj.isMod(MDI_ADD))
      {
	 // added a manager
	 if (mainView()->viewManagers->isChecked())
	    view()->managerView()->itemAdd(obj);
	 break;
      }
      else if (obj.isMod(MDI_REMOVE))
      {
	 // removed a manager
	 KObject prev;
	 if (currentManager() == obj)
	 {
	    prev = view()->managerView()->itemAbove(obj);
	    if (prev.isNull())
	       prev = view()->managerView()->itemBelow(obj);
	 }
	 if (mainView()->viewManagers->isChecked())
	    view()->managerView()->itemRemove(obj);
	 if (currentManager() == obj)
	    setCurrentManager(prev.toTManager());
	 obj.deleteInstance();
	 break;
      }
      else if (obj.isMod(MDI_CLEAR))
      {
	 // manager cleared
	 setCurrentTransfer(KTransfer::null());
	 mainView()->updateManagerMenu();
	 //mainView()->updateTransferMenu();
	 mainView()->updateStatusBarBand();
	 mainView()->updateStatusBarCount();
	 //updateToolTip();
      }
      if (obj.isMod(MDI_CNT) || obj.isMod(MDI_ACTCNT))
      {
	 // added or removed a transfer from this tmanager
	 mainView()->updateStatusBarCount();
	 //updateToolTip();
      }
      if (obj.isMod(MDI_TMN_TITLE))
      {
	 // change manager title
	 mainView()->updateManagerMenu();
      }
      if (currentManager() == obj)
      {
	 if (obj.isMod(MDI_START))
	 {
	    mainView()->managerKillAll->setEnabled(true);
	 }
	 if (obj.isMod(MDI_STOP))
	 {
	    mainView()->managerKillAll->setEnabled(false);
	 }
	 if (obj.isMod(MDI_TMN_CFG_AUTODWNL))
	 {
	    mainView()->managerAutoDownload->setChecked(obj.toTManager().getAutoDownload());
	    mainView()->updateTransferMenu();
	 }
	 if (obj.isMod(MDI_PRIORITY) && mainView()->viewManagers->isChecked())
	 {
	    view()->transferView()->reset();
	 }
	 if (obj.isMod(MDI_CLEAR))
	    view()->transferView()->reset();
      }
      //FIXME??
      // update manager view
      if (mainView()->viewManagers->isChecked())
	 view()->managerView()->itemUpdate(obj);
      break;
   case TYP_TWGET:
   case TYP_TKIO:
      if (obj.isMod(MDI_START))
      {
	 if (getEnableNotify())
	    KNotifyClient::event("transferStart", i18n("transfer start: ") +
				 obj.toTransfer().remote().prettyURL());
	 if (getAutoProgress() && mainView()->_progressWnds[obj.id()] == 0)
	    mainView()->openTransferProgress(obj.toTransfer());
      }
      if (obj.isMod(MDI_STOP))
      {
	 if (getEnableNotify() && obj.toTransfer().state() == TRN_END_ERROR)
	    KNotifyClient::event("transferError", i18n("transfer error: ") +
				 obj.toTransfer().remote().prettyURL());
	 if (getEnableNotify() && obj.toTransfer().isComplete())
	    KNotifyClient::event("transferComplete",
				 i18n("transfer complete: ") +
				 obj.toTransfer().remote().prettyURL());
	 if (getAutoProgress() && obj.toTransfer().isComplete()
	     && mainView()->_progressWnds[obj.id()] != 0)
	    mainView()->_progressWnds[obj.id()]->close();
      }
      if (obj.container() == currentManager())
      {
	 // if transfer is in current manager
	 if (obj.isMod(MDI_ADD))
	 {
	    // added a transfer to current tmanager
	    view()->transferView()->itemAdd(obj);
	    mainView()->updateTransferMenu();
	    break;
	 }
	 else if (obj.isMod(MDI_REMOVE))
	 { // removed a transfer from current manager
	    KObject prev;
	    if (currentTransfer() == obj)
	    {
	       prev = view()->transferView()->itemAbove(obj);
	       if (prev.isNull())
		  prev = view()->transferView()->itemBelow(obj);
	    }
	    mainView()->closeTransferWindows(obj.toTransfer());
	    view()->transferView()->itemRemove(obj);
	    //mainView()->updateTransferMenu();
	    if (currentTransfer() == obj)
	       setCurrentTransfer(prev.toTransfer());
	    obj.deleteInstance();
	    break;
	 }
	 else if (obj.isMod(MDI_START))
	 {
	    mainView()->updateTransferMenu();
	 }
	 else if (obj.isMod(MDI_STOP))
	 {
	    mainView()->updateTransferMenu();
	 }
	 else if (obj.isMods(CFGMOD) || obj.isMod(MDI_GLOBAL))
	 {
	    mainView()->updateTransferMenu();
	 }
	 else if (obj.isMod(MDI_CLEAR))
	 {
	 }
	 else if (obj.isMod(MDI_TRN_PARTIAL))
	 {
	    view()->transferView()->itemUpdateText(obj);
	    break;
	 }
	 view()->transferView()->itemUpdate(obj);
      }
      break;
   default:
      kdFatal() << "updateView: object type " << obj.type() << " unknown" << endl;
   }
}

bool KMagoDoc::event(QEvent *event)
{
   if (event->type() == QEvent::User)
   {
      DocEvent *e = dynamic_cast<DocEvent*>(event);
      if (e->obj().isMods(ANYMOD))
      {
	 updateView(e->obj());
	 if (!e->obj().isNull())
	    e->obj().resetMods();
      }
      return true;
   }
   return QObject::event(event);
}

/////////////////////////////////////////////////////////////////////////

void KMagoDoc::slotTransferStart()
{
   //kdDebug(D_VIE) << name() << ": slotTransferStart" << endl;
   if (isClosed())
      return;
   manager().startPendingTransfer();
}

void KMagoDoc::slotUpdate()
{
   //kdDebug(D_RUN) << name() << ": update" << endl;
   if (isClosed())
      return;
   manager().runPeriodically();
}

void KMagoDoc::slotSave()
{
   if (!isClosed() && manager().isModified())
      manager().save();
}

#include "kmagodoc.moc"
