/***************************************************************************
			   kdlgopentransfer.h  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.14 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGOPENTRANSFER_H
#define KDLGOPENTRANSFER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <kurlrequester.h>
#include <kcombobox.h>
//Generated area. DO NOT EDIT!!!(end)

#include <klocale.h>
#include <kdialogbase.h>
#include <qdir.h>
#include <kurl.h>
#include <qfileinfo.h>
#include <qvaluelist.h>
//#include <qdir.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

class KMagoDoc;
class KTManager;

/**
 * @short Dialog to insert a new transfer
 *
 * TODO:
 * disable the default button, cause it catch "return" that is
 * needed for automatic file completion
 *
 * @author Sergio Moretti
 *
 * @version $Id: kdlgopentransfer.h,v 1.14 2001/03/23 17:14:59 sergio Exp $
 */

class KDlgOpenTransfer : public KDialogBase
{
   Q_OBJECT

public:
   KDlgOpenTransfer(QWidget *parent, const char *name=0);
   ~KDlgOpenTransfer();
   static bool getOpenTransfer(KMagoDoc *doc, KTManager &mngr, KURL &rmt, 
			       KURL &lcl, int &type);
   //virtual QSize sizeHint() const { return QSize(300, 200); }

protected:
   void init(KMagoDoc *doc, KTManager mngr, const KURL &rmt, const KURL &lcl);
   void initDialog();
   /** correct file name */
   QString correctFile(const QString &f);
   /** correct url */
   //KURL correctURL(const QString &u);
   /** update the type list */
   void updateType();
   KMagoDoc * doc() const;

protected slots:
   /** open file dialog to select filename */
   //void slotOpenFileDlg();
   /** close the dialog acceptiong the selection */
   void slotOk();
   /** create the file name, based on the url */
   void slotReadURL(const QString &u);
   void slotSelectManager(int i);

protected:
   KComboBox *cmbURL;
   KURLRequester *cmbFile;
   KComboBox *cmbType;
   KComboBox *cmbManager;

private:
   /** file to write */
   KURL _lcl;
   /** url to download */
   KURL _rmt;
   /** transfer type */
   int _type;
   /** current manager */
   KTManager _mngr;
   /** current document object */
   KMagoDoc *_doc;
   /** convert index to type */
   QValueList<int> _typeList;
   /** dialog instance */
   static KDlgOpenTransfer *dlg;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
