//****************************************************************
//** digital simulation 
//** 
//** Andreas Rostin
//** 12.10.1997
//****************************************************************
#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klogic.h>
#include <version.h>
#include <mainw.h>
#include <xdevice.h>

// unique-id counter
int uniqueID::id = 0;

// global constants
//const QString Global::EMPTYSTRING;
const QString Global::Klogic::Name = "klogic";
const QString Global::Klogic::emptyFileName = i18n("new.circuit");

int Global::Screen::VIRT_SCREEN_SIZE_X = 2600;
int Global::Screen::VIRT_SCREEN_SIZE_Y = 1200;

QString Global::CurrentCircuit::filename;
QString Global::CurrentCircuit::version;
QString Global::CurrentCircuit::creation;
QString Global::CurrentCircuit::author;
QString Global::CurrentCircuit::title;
QString Global::CurrentCircuit::comment;

int Global::Device::m_iDelay = Global::Device::DEFAULT_DELAY;
int Global::Device::m_iUndefinedValue = Global::Device::DEFAULT_UNDEFINED_VALUE;
Global::Device::CLOCKTYPE Global::Device::m_iClock = Global::Device::DEFAULT_CLOCK;
int Global::Device::m_iSize = Global::Device::DEFAULT_SIZE;
bool Global::Device::m_bInvert = Global::Device::DEFAULT_INVERTED;
bool Global::Device::m_bDisplayNames = Global::Device::DEFAULT_DISPLAY_NAMES;

QString Global::Device::DEFAULT_FONTFAMILY = "adobe-courier";
int Global::Device::DEFAULT_FONTSIZE = 8;
int Global::Device::DEFAULT_FONTAPPEARANCE = QFont::Normal;
QString Global::Device::m_sFontFamilyName = Global::Device::DEFAULT_FONTFAMILY;
QFont Global::Device::m_oFont = QFont(Global::Device::m_sFontFamilyName, Global::Device::DEFAULT_FONTSIZE, Global::Device::DEFAULT_FONTAPPEARANCE);
int Global::Device::m_iFontSize = Global::Device::DEFAULT_FONTSIZE;
int Global::Device::m_iSymbolSet = Global::Device::SYMBOLSET_DIN40900;

int Global::Device::m_iWidth = Global::Device::DEFAULT_WIDTH;

int Global::Device::Counter[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				 0, 0, 0, 0, 0, 0};
QString Global::Device::Name[] = {"and", "or", "inv", "xor", "7s", "switch", "osc", "", "rs", "d",
                             "jk", "led", "in", "out", "net", "pwr", "text", "sub", "led", "led",
                             "led", "tri", "ram", "", "", "t"};

void Global::Device::setDelay(int iDelay)
{
	if (iDelay > Global::Device::MAXDELAY)
		iDelay = Global::Device::MAXDELAY;
	if (iDelay < Global::Device::MINDELAY)
		iDelay = Global::Device::MINDELAY;
	Global::Device::m_iDelay = iDelay;
}

int Global::Device::getDelay()
{
	return m_iDelay;
}

void Global::Device::setUndefinedValue(int iUndefinedValue)
{
	m_iUndefinedValue = iUndefinedValue;
}

int Global::Device::getUndefinedValue()
{
	return m_iUndefinedValue;
}

void Global::Device::setClock(Global::Device::CLOCKTYPE iClock)
{
	switch (iClock) {
		case CLK_RISING_2EDGE:
			iClock = CLK_RISING_1EDGE;
			break;
		case CLK_FALLING_2EDGE:
			iClock = CLK_FALLING_1EDGE;
			break;
		default:
			break;
	}
	m_iClock = iClock;
}

Global::Device::CLOCKTYPE Global::Device::getClock()
{
	switch (m_iClock) {
		case CLK_RISING_2EDGE:
			m_iClock = CLK_RISING_1EDGE;
			break;
		case CLK_FALLING_2EDGE:
			m_iClock = CLK_FALLING_1EDGE;
			break;
		default:
			break;
	}
	return m_iClock;
}

void Global::Device::setSize(int iSize)
{
	if (iSize < Global::Device::MINSIZE)
		iSize = Global::Device::MINSIZE;
	if (iSize > Global::Device::MAXSIZE)
		iSize = Global::Device::MAXSIZE;
	m_iSize = iSize;
}

int Global::Device::getSize()
{
	return m_iSize;
}

void Global::Device::setInverted(bool bInvert)
{
	m_bInvert = bInvert;
}

bool Global::Device::isInverted()
{
	return m_bInvert;
}

void Global::Device::setDisplayNames(bool bDisplayNames)
{
	m_bDisplayNames = bDisplayNames;
}

bool Global::Device::isDisplayNames()
{
	return m_bDisplayNames;
}

void Global::Device::setFontFamily(const QString &sFontFamilyName)
{
	m_sFontFamilyName = sFontFamilyName;
	m_oFont = QFont(m_sFontFamilyName, m_iFontSize, Global::Device::DEFAULT_FONTAPPEARANCE);
}

const QString& Global::Device::getFontFamily()
{
	return m_sFontFamilyName;
}

const QFont& Global::Device::getFont()
{
	return m_oFont;
}

void Global::Device::setFontSize(int iFontSize)
{
	m_iFontSize = iFontSize;
}

int Global::Device::getFontSize()
{
	return m_iFontSize;
}

void Global::Device::setWidth(int iWidth)
{
	m_iWidth = iWidth;
}

int Global::Device::getWidth()
{
	return m_iWidth;
}

void Global::Device::setSymbolSet(int iSymbolSet)
{
        m_iSymbolSet = iSymbolSet;
}

int Global::Device::getSymbolSet()
{
        return m_iSymbolSet;
}

QString Global::Device::getName(int iFunction)
{
	Counter[iFunction - DeviceType::fBASE]++;
	QString sName = Name[iFunction - DeviceType::fBASE];
	sName.append(QString::number(Counter[iFunction - DeviceType::fBASE]));
	return sName;
}

static KCmdLineOptions options[] =
{
	{ "+[File]", i18n("file to open"), 0 },
	{ 0, 0, 0 }
};

int main( int argc, char **argv )
{
	MainWidget *poMainW;

	uniqueID::reset();

	KAboutData aboutData(Global::Klogic::Name, Global::Klogic::Name,
		VERSION, i18n("digital circuit simulator"), KAboutData::License_GPL,
		"(c) 2003 Andreas Rostin", 0, 0, "andreas@a-rostin.de");

	aboutData.addAuthor("Andreas Rostin",0, "andreas@a-rostin.de");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options );

	// app
	KApplication *poApp = new KApplication;

	// main-widget
	if (poApp->isRestored()) {
		RESTORE(MainWidget(poApp));
	} else {
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		if (args->count() == 1)
			poMainW = new MainWidget(poApp, args->arg(0));
		else
			poMainW = new MainWidget(poApp);
		args->clear();
		poApp->setMainWidget(poMainW);
    		poMainW->show();
	}

	XDevice::m_oBasicImageCache.init();

    	return poApp->exec();

	delete poMainW;
}

