/**************************************************************************/
/*  Klavaro - a flexible touch typing tutor                               */
/*  Copyright (C) 2005 - 2008  Felipe Castro                              */
/*                                                                        */
/*  This program is free software, licensed under the terms of the GNU    */
/*  General Public License as published by the Free Software Foundation,  */
/*  which is also included in this package, in a file named "COPYING".    */
/**************************************************************************/

/*
 * Adaptability exercise
 */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib.h>
#include <gtk/gtk.h>

#include "support.h"
#include "keyboard.h"
#include "tutor.h"
#include "adaptability.h"

/**********************************************************************
 * Global variables
 */
extern GtkWidget *window_tutor_;

/**********************************************************************
 * Writes a random pattern of weird words in the exercise window
 */
void
adapt_draw_random_pattern ()
{
	gint i, j, k;
	gint tidx;
	gchar *utf8_text;
	gunichar text[WORDS * (MAX_WORD_LEN + 1) + 3];
	gunichar word[MAX_WORD_LEN + 1];

	for (i = 0; i < LINES; i++)
	{			/* paragraphs per exercise */
		tidx = 0;
		for (j = 0; j < WORDS; j++)
		{		/* words per paragraph */
			if (rand () % 15)
				adapt_create_word (word);
			else
				adapt_create_number (word);

			if (j == 0)
				word[0] = g_unichar_toupper (word[0]);
			else
				text[tidx++] = L' ';

			for (k = 0; word[k] != L'\0'; k++)
				text[tidx++] = word[k];
		}
		text[tidx++] = L'.';
		text[tidx++] = L'\n';
		text[tidx++] = L'\0';
		utf8_text = g_ucs4_to_utf8 (text, -1, NULL, NULL, NULL);
		tutor_draw_paragraph (utf8_text);
		g_free (utf8_text);
	}
}

/*
 * Creates a random weird word
 */
void
adapt_create_word (gunichar word[MAX_WORD_LEN + 1])
{
	gint i, n;
	gint vlen, clen, slen;
	gunichar vowels[20];
	gunichar consonants[4 * KEY_LINE_LEN];
	gunichar symbols[4 * KEY_LINE_LEN];

	vlen = keyb_get_vowels (vowels);
	clen = keyb_get_consonants (consonants);
	slen = keyb_get_symbols (symbols);

	n = rand () % (MAX_WORD_LEN - 1) + 1;
	for (i = 0; i < n; i++)
	{
		if ((rand () % 25))
		{		/* literal */
			if (i % 2)	/* vowel */
				if (rand () % 30)
					word[i] = vowels[rand () % vlen];
				else
					word[i] = consonants[rand () % clen];
			else if (rand () % 50)	/* consonant */
				word[i] = consonants[rand () % clen];
			else
				word[i] = vowels[rand () % vlen];

			if (i == 0 && !(rand () % 5))	/* capital */
				word[0] = g_unichar_toupper (word[0]);
		}
		else
		{		/* symbol */
			word[i] = symbols[rand () % slen];
			if (rand () % 3)
			{	/* space after symbol */
				word[i + 1] = L'\0';
				return;
			}
		}
	}
	/*
	 * Last char
	 */
	if (rand () % 20)
		word[n] = vowels[rand () % vlen];
	else
		word[n] = L',';	/* consonants[rand () % clen]; */

	/*
	 * Null terminated unistring
	 */
	word[n + 1] = L'\0';
}

/*
 * Creates a random number
 */
void
adapt_create_number (gunichar ucs4_word[MAX_WORD_LEN + 1])
{
	gchar word[10];
	gunichar *tmp_ucs4;
	glong n;

	if (rand () % 3)
		snprintf (word, MAX_WORD_LEN + 1, "%i", rand () % 3101 - 999);
	else
		snprintf (word, MAX_WORD_LEN + 1, "%.2f",
			  (rand () % 10000 - 2000) + (rand () % 100) / 100.0);
	word[MAX_WORD_LEN] = '\0';

	tmp_ucs4 = g_utf8_to_ucs4_fast (word, -1, &n);
	memcpy (ucs4_word, tmp_ucs4, n * sizeof (gunichar));
	g_free (tmp_ucs4);
	ucs4_word[n] = L'\0';
}

/**********************************************************************
 * Put on the screen the final comments
 */
void
adapt_comment (gdouble accuracy)
{
	gchar *tmp_str;
	GtkWidget *wg;
	GtkTextBuffer *buf;

	/*
	 * Comments
	 */
	if (accuracy < 50)
		tmp_str =
			g_strdup (_
				  (" You must be kidding.\n" " Your error rate is too high!\n"
				   " Please do it right.\n"));

	else if (accuracy < 90)
		tmp_str = g_strdup (_(" You are not ready to practice this exercise.\n"
				      " Your accuracy rate is below 90 %...\n"
				      " Try to accomplish most of the basic course lessons.\n"));
	else if (accuracy < 95)
		tmp_str =
			g_strdup (_
				  (" You are doing well. But...\n"
				   " Could you make the accuracy reach at least 95 %?\n"));
	else if (accuracy < 99)
		tmp_str = g_strdup (_(" You are almost there,"
				      " but your accuracy rate is still below 99 %.\n"
				      " Try a few more times,"
				      " so that I can evaluate your velocity.\n"));
	else
		tmp_str = g_strdup (_(" Very good!\n"
				      " You succeeded with an accuracy rate above 99 %.\n"
				      " Now it is time to increase your velocity.\n"
				      " Go to the 3rd exercise at the main menu.\n"));

	wg = lookup_widget (window_tutor_, "text_tutor");
	buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (wg));
	gtk_text_buffer_insert_at_cursor (buf, tmp_str, strlen (tmp_str));
	g_free (tmp_str);
}
