#ifdef USE_DISTRIBUTED_STORE


#ifdef DEBUG
#include <assert.h>
#endif

#include <stdio.h>
#include <stdlib.h>

//#define DEBUG_PROXY
//#define DEBUG_PROXY_WITH_DUMP


//Socket stuff

#include <sys/types.h>
#include <sys/socket.h>

#include<netinet/in.h>
#include<netdb.h>
#include<ctype.h>
#include<errno.h>
#include<signal.h>
#include<stdio.h>
#include<fcntl.h>
#include<resolv.h>


//We use threads
#include <pthread.h>

//For the Store Interface
#include "store.h"
#include "store_communication.h"

//To communicate with the Virtual Disk Cache
#include "virtual_disk_cache.h"


//This is the socket that is connected to the Virtual Disk Cache
static int proxySocket = 0;
//Flag to indicate whether we have connected the VDC yet or not
static int initializedProxy = 0;

//Variable used as we parse the virtual_disk_cache.rc file, which contains a list of VDCs we can potentially connect to.

int num_virtual_disk_cache_entries = 0;

/* Structure used to represent each VDC, just has the IP address 
   We allow for up to 16 caches, we only need to connect to one of them anyway
*/

struct virtual_disk_cache_entry {
  struct sockaddr_in sin;
} virtual_disk_cache_entries[16];

/* We reuse this command many times when sending commands to the VDC */

struct virtual_disk_command command;

/* We have two counters which we increment as we allocate more object entries and data blocks. We will initialize them later */

int free_object_entry = -1;
int free_data_block = -1;

/* This helper method just checks to see if the socket is broken and quits */

void handle_read_result(int arg)
{
  if( arg == 0)
    {
      //EOF - terminate
      exit(1);
    }
  else if(arg == -1)
    {
      //Error - terminate
      perror("handle_read_result");
      exit(2);
    }
}

/* This method is called to connect the proxy to the VDC */

int initializeProxy()
{
  /* Socket stuff */
  struct sockaddr_in sin;
  struct in_addr ina;
  struct hostent* host_info;
  /* We need to read our rc file */
  FILE* file;

  if(initializedProxy != 0)
      {
	  fprintf(stderr, "Why are you intializing the proxy twice !!!?\n");
	  exit(17);
      }

#ifdef DEBUG_PROXY  
  printf("?Initialize proxy on port %i\n", PROXY_PORT);
#endif


  /* Create the socket */

  proxySocket = socket(PF_INET, SOCK_STREAM, 0);

  if(proxySocket < 0)
    {
      perror("initializeProxy socket");
      return -1;
    }

  sin.sin_family = AF_INET;

  /* Read in the configuration file for potential VDCs to connect to */
  
  printf("Looking for virtual_disk_cache.rc\n");
  file = fopen("virtual_disk_cache1.rc", "r");
  if(file != NULL)
    {
      char buffer[256];
      char* res;
      while((res = fgets(buffer, 256, file)) != NULL)
	{
	    char* next = (char*) strtok(buffer, " "); //Items are separated by spaces
    if(inet_aton(next, &ina) == 0)
	{
	  printf("Host %s\n", next);
	    perror("initialize_remote_socket");
	    	    exit(7);
	}
	  next = (char*) strtok(NULL, " ");

	  /* Set the IP address and port */
	  sin.sin_port = virtual_disk_cache_entries[num_virtual_disk_cache_entries].sin.sin_port = htons(atoi(next));
	  sin.sin_addr.s_addr = virtual_disk_cache_entries[num_virtual_disk_cache_entries].sin.sin_addr.s_addr = ina.s_addr;
	  num_virtual_disk_cache_entries++;
	  break;
	}
      fclose(file);
    }
  else
    {
	/* Use the local machine as a VDC */
      printf("No file found, connecting to localhost, default port\n");
      sin.sin_addr.s_addr = INADDR_ANY;
      sin.sin_port = htons(PROXY_PORT);
    }
  printf("Connecting ...\n");

  /* Connect to the VDC we have chosen */
  if(connect(proxySocket, &sin, sizeof(sin)) != 0)
    {
      printf("Initialize proxy failed to connect() to %s\n", inet_ntoa(virtual_disk_cache_entries[0].sin.sin_addr));
      perror("Initialize proxy failed to connect() ");
      //      throw new StoreNotFoundException("Connection to disk cache lost");
      exit(55);
    }

  //Get our own ip information
  host_info = gethostbyname("localhost");

  
  initializedProxy = 1;
}

/*
 * Closes an open store.
 *
 * We use this method to shutdown the connection to the proxy
 */

void STORE_CloseStore
(
  void
)
{
int amt_written;
#ifdef DEBUG_PROXY  
  printf("?PROXY_CloseStore\n");
#endif

if(initializedProxy == 1)
  {
	  int result;

	  /* Our first task when shutting down is to save the highest free_object_entry  and free_data_block

	   */
	  command.command = VIRTUAL_DISK_WRITE;
	  command.address = 0x10000L;
	  command.offset = 4;
	  command.length = sizeof(int);
	  
	  if(free_object_entry < 5)
	      free_object_entry = 5;

	  write(proxySocket, &command, sizeof(struct virtual_disk_command));
	  write(proxySocket, &free_object_entry, sizeof(free_object_entry));
	  read(proxySocket, &result, sizeof(result));
	  if(result != -1)
	      {

	      }
	  else
	      {
		  printf("Could not write highest object entry\n");
	      }

	  command.command = VIRTUAL_DISK_WRITE;
	  command.address = 0x10000L;
	  command.offset = 8;
	  command.length = sizeof(int);

	  if(free_data_block < 5)
	      free_data_block = 5;
	  write(proxySocket, &command, sizeof(struct virtual_disk_command));
	  write(proxySocket, &free_data_block, sizeof(free_data_block));
	  read(proxySocket, &result, sizeof(result));
	  if(result != -1)
	      {

	      }
	  else
	      {
		  printf("Could not write highest data block\n");
	      }

	  /* Now we send the shutdown instruction */
      command.command = VIRTUAL_DISK_CLOSE_PROXY_CONNECTION;
      command.address = 0L;
      command.length = 0;
      command.offset = 0;

      amt_written = write(proxySocket, &command, sizeof(struct virtual_disk_command));
      assert(amt_written == sizeof(struct virtual_disk_command));

      /* And shutdown */
      close(proxySocket);
      initializedProxy = 0;
  }
}

/*
 * Gets the root object's PID
 *
 */

PID STORE_GetRootPID
(
  void
)
{
    PID pid;
    int amt_read;
if(initializedProxy == 0)
    initializeProxy();
if(initializedProxy == 1)
  {


    long long address = 0x10000L;
    int result;

#ifdef DEBUG_PROXY  
  printf("?PROXY_GetRootPID is intialized\n");
#endif

    pid = 0;

    /* We read the root PID at address 0x10000L */

    command.command = VIRTUAL_DISK_READ;
    command.address = address;
    command.offset = 0;
    command.length = sizeof(pid);

    amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
    assert(amt_read == sizeof(struct virtual_disk_command));
    
    amt_read = read(proxySocket, &result, sizeof(result));
	

    assert(amt_read == sizeof(result));
    if(result == sizeof(pid))
	{
	    amt_read = read(proxySocket, &pid, sizeof(pid));
	    assert(amt_read == sizeof(pid));
	}

#ifdef DEBUG_PROXY  
  printf("?PROXY_GetRootPID returned %x\n", pid);
#endif

  /* The result is the pid */

  return pid;
  }
else 
    {
	assert(1 == 2);
	return 0;
    }
}

/*
 * Set the root object's PID: NEVER USE! (except where needed)
 *
 */

void STORE_SetRootPID
(
  PID pid
)
{
int amt_read;
#ifdef DEBUG_PROXY  
  printf("?PROXY_SetRootPID\n");
#endif


if(initializedProxy == 1)
  {

      /* This time we write the pid to address 0x10000L*/

    long long address = 0x10000L;
    int result;

#ifdef DEBUG_PROXY  
  printf("?PROXY_SetRootPID is intialized\n");
#endif

  /* This time we write the PID to address 0x10000L*/

    command.command = VIRTUAL_DISK_WRITE;
    command.address = address;
    command.offset = 0;
    command.length = sizeof(pid);

    amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
    assert(amt_read == sizeof(struct virtual_disk_command));
    amt_read = write(proxySocket, &pid, sizeof(pid));
    assert(amt_read == sizeof(pid));

    amt_read = read(proxySocket, &result, sizeof(result));
    assert(amt_read == sizeof(result));

if( result == -1)
  {
    printf("set_root_pid failed\n");
    exit(227);
  }
else 
  {
      //    printf("set_root_pid ok\n");
  }

  }
else
    {
	assert(1 == 2);
    }
}

/*
 * Gets the size of an object in the store.
 *
 */

int STORE_GetObjectSize
(
  PID pid
)
{
  int objsize;
  int amount, amt_read;
  long long address;
  int success, result;
  long long offset;
  int* buf;

  if(initializedProxy == 1)
      {
  
	if(pid == 0)
	  {
	      printf("!!! PID is %x in GetObjectSize !!!!!!!!!!!!!!!!\n", pid);
	      return -1;

	  }
	  if(pid >= 0)
	      {
		  printf("!!! PID is %x in GetObjectSize\n", pid);
	      }
	  assert(pid < 0);

  /* Allocate some memory for the object entry */

  buf = (int*) malloc(512);
  assert(buf != NULL);

#ifdef DEBUG_PROXY
    printf("Store manager: get object size, pid %x\n", pid);
#endif

    /* Find the object size */
    
    //We first need to read the object entry, so lets calculate where that would be
    address = 0x400000000000L + ((-pid) * 512);
    offset = (address % BLOCK_SIZE);

#ifdef DEBUG_PROXY
	printf("proxy_get_object_size address %x %x, offset %i\n", (int) ((address) >> 32), (int) (((address)<< 32) >> 32), offset);
#endif

    //Now read that object entry
    command.command = VIRTUAL_DISK_READ;
    command.address = address - offset;
    command.offset = offset;
    command.length = 512;

    amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
    assert(amt_read == sizeof(struct virtual_disk_command));
    amt_read = read(proxySocket, &result, sizeof(result));
    assert(amt_read == sizeof(result));


    if(result == -1)
      {
	printf("proxy_get_object_size failed ot read in getobjectsize\n");
	exit(52);
      }
    else
      {

	int i = 0;

	amt_read = read(proxySocket, buf, command.length);
	assert(amt_read == command.length);

	assert(buf[0] != 0);
#ifdef DEBUG_PROXY	    
	printf("get_object_size Object entry for %x is: size %i, blocks %i, pid %x\n", buf[0], buf[1], buf[3], pid);
#endif

	/* Get the object size from the object entry */
	objsize = buf[1];
      }
      }
    else
	{
	    assert(1 == 2);
	}

    return objsize; 
}

/*
 * Loads an object from the store.
 *
 */

void STORE_LoadObject
(
  PID pid,
  char* obj
)
{
  int objsize;
  int* buf;
  long long address;
  long long lock_address;
  int result, amt_read;
  int offset; //Offset within the page we want to read

  if(initializedProxy == 1)
      {

	  /* Allocate memory for the object entry*/
  buf = (int*) malloc(512);

#ifdef DEBUG_PROXY
  printf("/store_proxy load object pid %x\n", pid);
#endif
  assert(pid < 0);
  assert(buf != NULL);

   //Which is in this 4k block

    //We first need to read the object entry, so lets calculate where that would be
    address = 0x400000000000L + ((-pid) * 512);
    offset = (address % BLOCK_SIZE);

#ifdef DEBUG_PROXY
	printf("proxy_load_object address %x %x, offset %i\n", (int) (address >> 32), (int) ((address << 32) >> 32), offset);
#endif

	/* Read the object entry */
	
     assert(offset >= 0);
    command.command = VIRTUAL_DISK_READ;
    command.address = address - offset;
    command.offset = offset;
    command.length = 512;

    //    success = GAMMA_read(address - offset, buf, offset, 512);

    amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
    assert(amt_read == sizeof(struct virtual_disk_command));
    amt_read = read(proxySocket, &result, sizeof(result));
    assert(amt_read == sizeof(result));
    if(result == -1)
       {
	printf("proxy_load_object failed to read objsize, at %x %x\n", (int) (address >> 32), (int)((address << 32) >> 32));
	exit(22);
      }
    else
      {
	/* Find the object size */
	int numblocks = 0;
	int i = 0;
	int j = 0;

	amt_read = read(proxySocket, buf, 512);
	assert(amt_read == 512);

	/* Number of data blocks */
	numblocks = buf[3];
	/* Object size */
	objsize = buf[1];

	assert(buf[0] != 0);

#ifdef DEBUG_PROXY
	printf("(load) Object entry for %x is: size %i, blocks %i\n", buf[0], buf[1], buf[3]);
#endif

  /* Now we have to read each block */

	for(i = 0; i < numblocks; i++)
	  {
	      /* Compute the address for the block and the amount of data we want to read */
	    int about_to_read = 4096;
	    int block_index = buf[4 + i];
	    address = 0x500000000000L + block_index * 4096;

	    //	    printf("--Block index is %i\n", block_index);

	    assert(address >= 0x500000000000L);
#ifdef DEBUG_PROXY
	printf("(load) reading block at %x %x\n", (int) (address >> 32), (int) ((address << 32) >> 32));
#endif
	    if(objsize < ((i+1) * 4096))
	      about_to_read = objsize % 4096;

#ifdef DEBUG_PROXY	    
	    printf("load_object About to read %i bytes from alpha\n", about_to_read);
#endif

	    /* Read the block */
	    
	    command.command = VIRTUAL_DISK_READ;
	    command.address = address;
	    command.offset = 0;
	    command.length = about_to_read;

	    amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
	    assert(amt_read == sizeof(struct virtual_disk_command));
	    amt_read = read(proxySocket, &result, sizeof(result));
	    assert(amt_read == sizeof(result));


	    
	    //success = GAMMA_read(address, mem + (i * 4096), 0, about_to_read);
	    if(result == -1)
	      {
		printf("load_object read failed ************\n");
		exit(2);
 	      }

	    /* Make sure we get all the data */
	    amt_read = read(proxySocket, obj + (i * 4096), about_to_read);
	    while(amt_read < about_to_read)
		{
		    amt_read += read(proxySocket, obj + (i * 4096) + ( amt_read), about_to_read - amt_read);
		}
	    assert(amt_read == about_to_read);

#ifdef DEBUG_PROXY_WITH_DUMP
	    {
		int j;
	    printf("proxy_load_object dumping object %x\n", pid);
	    for(j = 0; j < (about_to_read / 4);j++)
		printf("%x", *((int*) (obj + (i * 4096) + j * 4)));
	    printf("\n");
	    }
#endif

	  }

	

      }
      }
else
    {
	assert(1 == 2);
    }

#ifdef DEBUG_PROXY
  printf("\\store_proxy load object finished, pid %x\n", pid);
#endif
}



/*
 * Updates an existing object in the store with new data given.
 *
 */

void STORE_UpdateObject
(
  PID pid,
  void* obj
)
{
  int objsize;
  int* buf;
  long long address;
  long long lock_address;
  int result, success, amount, amt_read;
  int offset; //Offset within the page we want to read

if(initializedProxy == 1)
  {
#ifdef DEBUG_PROXY
  printf("?PROXY_UpdateObject is initialized pid %x\n", pid);
#endif

  /* Again, read the object entry  -- maybe we should make a method to do just this? */

    //We first need to read the object entry, so lets calculate where that would be
    address = 0x400000000000L + ((-pid) * 512);
    offset = (address % BLOCK_SIZE);

#ifdef DEBUG_PROXY
	printf("proxy_load_object address %x %x, offset %i\n", (int) (address >> 32), (int) ((address << 32) >> 32), offset);
#endif

    command.command = VIRTUAL_DISK_READ;
    command.address = address - offset;
    command.offset = offset;
    command.length = 512;

    //    success = GAMMA_read(address - offset, buf, offset, 512);

    amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
    assert(amt_read == sizeof(struct virtual_disk_command));
    amt_read = read(proxySocket, &result, sizeof(result));
    assert(amt_read == sizeof(result));
    if(result == -1)
       {
	printf("proxy_update_object failed ot read objsize\n");
	exit(22);
      }
    else
      {
	/* Find the object size */
	int numblocks = 0;
	int i = 0;
	int j = 0;

	buf = (int*) malloc(512);
	assert(buf != NULL);
	amt_read = read(proxySocket, buf, 512);
	assert(amt_read == 512);
	numblocks = buf[3];

	objsize = buf[1];

	assert(buf[0] != 0);

	//Now to update the object 
	//Now write each block
	for(i = 0; i < numblocks; i++)
	  {
	    int about_to_write = 4096;
	    address = 0x500000000000L + buf[4 + i] * 4096;
	    if(objsize < ((i+1) * 4096))
	      about_to_write = objsize % 4096;

	    command.command = VIRTUAL_DISK_WRITE;
	    command.address = address;
	    command.offset = 0;
if( i == (numblocks - 1))
	    command.length = objsize - ((numblocks -1) * BLOCK_SIZE);
else
    command.length = about_to_write;

//             printf("storeproxy writing block to disk %i\n", command.length); 

             amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
	     assert(amt_read == sizeof(struct virtual_disk_command));
	     amt_read = write(proxySocket, obj + (i * BLOCK_SIZE), command.length);
	     assert(amt_read == command.length);

	     amt_read = 0;
	     /* Make sure we write all the data */
	     while(amt_read < sizeof(success)) {
		 amt_read += read(proxySocket, &success, sizeof(success));
		 handle_read_result( amt_read );

	     }
	     
	     assert(amt_read ==  sizeof(success));

	    if(success == -1)
	      {
		printf("update_object Write failed\n");
		exit(22);
	      }

#ifdef DEBUG_PROXY_WITH_DUMP
	    {
		int j;
	    printf("proxy_load_object dumping object %x\n", pid);
	    for(j = 0; j < (command.length / 4);j++)
		printf("%x", *((int*) (obj + (i * 4096) + j * 4)));
	    printf("\n");
	    }
#endif
	  }
	free(buf);
      }
  

  }
else
    {
	
#ifdef DEBUG_PROXY
  printf("?PROXY_UpdateObject WASN'T initialized\n");
#endif
  assert(1 == 2);
    }
}


/* Returns the next free entry for an object entry */

int get_free_block()
{
    return free_object_entry++;
}

/* Mark a block as used in the allocation bitmap */

void mark_block_as_used(int bn)
{
  //Read from allocation bitmap
  //Allocation bitmap lives at 1 TB
  byte readval = 0;
  int result;
  int i, amt_read;
  long long address = 0x100000000000L; //1 TB
  int offset;


  offset = ( bn / 8 );

  if(offset > BLOCK_SIZE)
      {
	  address += (offset - (offset % BLOCK_SIZE));
	  offset = offset % BLOCK_SIZE;
      }
  assert(offset >= 0);
  //  printf("block_number is %i, offset is %i\n", bn, offset);
  assert(offset < BLOCK_SIZE);

  command.command = VIRTUAL_DISK_READ;
  command.address = address;
  command.offset = offset;
  command.length = sizeof(readval);

  assert(offset >= 0);

  amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
  assert(amt_read == sizeof(struct virtual_disk_command));
  amt_read = read(proxySocket, &result, sizeof(result));
  assert(amt_read == sizeof(result));
  
  //  success = GAMMA_read( address, &readval, offset, sizeof(readval));

  if(result == -1)
    {
	//      printf("-|-|-| Read failed, assuming 0\n");
      readval = 0;
    }
  else
      {
	  amt_read = read(proxySocket, &readval, sizeof(readval));
	  assert(amt_read == sizeof(readval));
      }
  //Set relevant bit
  /*
#ifdef DEBUG_PROXY
  printf("Readval before %x\n", readval);
#endif
  */

  readval = readval | ( 2 << (offset % 8));

  /*
#ifdef DEBUG_PROXY
  printf("Readval after %x\n", readval);
#endif
  */
  //Write back to allocation bitmap

  command.command = VIRTUAL_DISK_WRITE;
  command.address = address;
  command.offset = offset;
  command.length = sizeof(readval);

  amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
  assert(amt_read == sizeof(struct virtual_disk_command));
  amt_read = write(proxySocket, &readval, sizeof(readval));
  assert(amt_read == sizeof(readval));
  amt_read = read(proxySocket, &result, sizeof(result));
  assert(amt_read == sizeof(result));
  //  success = GAMMA_write( address, &readval, offset, sizeof(readval));

  if(result == -1 )
    {
      printf("mark_block_as_used failed\n");
      assert(1 == 2);
    }
}

void write_object_entry(long long address, int offset, int* payload);

/* creates a new object entry structure */

void create_object_entry(int bn, int objsize, int numblocks)
{
    long long address;
    int i;
    int offset;
    int* payload = (int*) malloc(512);

    /* Initialize it to 0 */

    for(i = 0; i < (512 / sizeof(int));i++)
	{
	    payload[i] = 0;
	}

    /* The entry has a 

       block_number (the pid)
       the object size in bytes
       unused 
       the number of data blocks this object occupies
    */

    payload[0] = bn;
    payload[1] = objsize;
    payload[2] = 0; //Small object
    payload[3] = numblocks;

    //Check that we don't overflow the object entry!

assert(numblocks <= ((512 - 4 * 4)) / 4);
if(numblocks <= 0)
    {
    printf("Num blocks is 0!!!!!!!!\n");
    exit(888);
    }
else
    {
	//	printf("--- There are %i blocks\n", numblocks);
    }

//For each block

    for(i = 0; i < numblocks;i++)
	{
	    /* First get the next free data block */
	    int block = free_data_block++;
	    if(block <= 0)
		{
		    int result;
		    command.command = VIRTUAL_DISK_READ;
		    command.address = 0x10000L;
		    command.offset = 8;
		    command.length = sizeof(int);

		    //		    printf("Block was %i\n", block);
		    write(proxySocket, &command, sizeof(struct virtual_disk_command));
		    read(proxySocket, &result, sizeof(result));
		    if(result != -1)
			{
			    read(proxySocket, &free_data_block, sizeof(free_data_block));
			    if(free_data_block <= 0)
				free_data_block = 22;
			    block = free_data_block++;
			}
		    else
			{
			    block++;
			}

		}
	    //	    printf("Block is %i\n");
	    assert(block >= 0);

	    /* Now record that block in the object header */
	    payload[4 + i] = block;

	}

    //    printf("Writing pid %x to block number %i\n", -bn, payload[4]);

    /* Write the object entry */

    address = 0x400000000000L + bn * 512;
    offset = address % BLOCK_SIZE;

    //	printf("storeproxy new object at %x %x\n", (int) ((address + offset) >> 32), (int)(((address + offset)<< 32) >> 32));

    write_object_entry(address - offset, offset, payload);
    // write_object_entry frees the payload
    //    free(payload);
}

/* Do the actual writing of the object entry */

void write_object_entry(long long address, int offset, int* payload)
{
  int result, amt_read;

  command.command = VIRTUAL_DISK_WRITE;
  command.address = address;
  command.offset = offset;
  command.length = 512;
  
  amt_read = write(proxySocket, &command, sizeof(struct virtual_disk_command));
  assert(amt_read == sizeof(struct virtual_disk_command));
  amt_read = write(proxySocket, payload, 512);
  assert(amt_read == 512);
  amt_read = read(proxySocket, &result, sizeof(result));
  assert(amt_read == sizeof(result));

  if(result == -1)
    {
      printf("write_object_entry FAILED %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
    }
  else
    {
#ifdef DEBUG_PROXY
      printf("write_object_entry wrote to address \n");
#endif
    }
    free(payload);
}

/*
 * Allocates a new object in the store - doesn't write it though... just
 * gives it a pid and writes its size... use STORE_UpdateObject to write
 * it once you have its pid.
 *
 */



PID STORE_NewObject
(
  int objsize
)
{
  int num_blocks = 0;
  int block_number = 0;


  if(initializedProxy == 1)
      {

  //  printf("proxy_new_object about to get free block\n"); 
  block_number = get_free_block();

  if(block_number <= 0)
      {
	  //We have to look for free block
	  int result;
	  command.command = VIRTUAL_DISK_READ;
	  command.address = 0x10000L;
	  command.offset = 4;
	  command.length = sizeof(int);

	  write(proxySocket, &command, sizeof(struct virtual_disk_command));
	  read(proxySocket, &result, sizeof(result));
	  if(result != -1)
	      {
		  read(proxySocket, &free_object_entry, sizeof(free_object_entry));
		  if(free_object_entry <= 0)
		      free_object_entry = 15;

		  //  printf("** free object entry %i s\n", free_object_entry);
		  block_number = get_free_block();

		  
	      }
	  else
	      {
		  //printf("** free object entry %i\n", free_object_entry);
		  block_number = get_free_block();
	      }
      }

  //  printf("** block_number is %i\n", block_number);
  assert(block_number >= 0);
  assert(objsize >= 0);

    //Check that there is a free block in allocation bitmap

    if(block_number == -1)
	{
	    printf("Could not get free block!\n");
	    exit(2);
	}
    else
	{

	}

    /* Mark this block as used */

    mark_block_as_used( block_number);

    //Calc how many blocks
    num_blocks = objsize / (int) BLOCK_SIZE;
    if((objsize % BLOCK_SIZE) != 0)
	num_blocks += 1;

    //    printf("objsize %i, block_size %i, blocks %i, %i\n", objsize, (int) BLOCK_SIZE, num_blocks, objsize / BLOCK_SIZE);

    /* Create an object entry */
    create_object_entry(block_number, objsize, num_blocks);

    /* This is the PID */
    block_number = -block_number;

#ifdef DEBUG_PROXY
  printf("?PROXY_NewObject returned %x\n", block_number);
#endif

    return block_number; //This is the new pid


    //    write(fd, &block_number, sizeof(int));

      }
  else
      {
	  assert(2 == 4);
      }
#ifdef DEBUG_PROXY
    printf("Creating new object %x (%i bytes)\n", block_number, objsize);
#endif
}

/* The following methods just return true, they don't make sense anymore */

/*
 * Opens an existing persistent store.
 *
 */

int STORE_OpenStore
(
  const char* storename
)
{
  initializeProxy();
  return 1;
}

/*
 * Opens a new persistent store.
 *
 */

int STORE_NewStore
(
  const char* storename
)
{
  initializeProxy();
  return 1;
}





#endif












