#include <config.h>



#ifdef KISSME_LINUX_HOST
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

 #define eprintf(format, args...) fprintf(stderr, format, ## args)
#endif

#ifdef VERIFIER

#include "../stdtypes.h"
#include "../interp.h"
#include "../disass.h"
#include "../sys_linux_host/wrappers.h"
#include "../stackmap/mapencoder.h"
#include "../opcodes.h"
#include "verifier.h"

#include "../stackmap/stackmap.h"

extern struct byteCodeInfo infoTable[];

int verifyMethod(byte* pbCode, int* retLength, int numBytes, tMethod* pstMethod, tClass* pstClass) 
{
  int* instructionIndex;
  int rawIndex = 0;
  int instructionIndexIndex = 0;
  int success = 0;

  instructionIndex = (int*) sys_malloc( numBytes * sizeof(int));
  //We won't use all of these

eprintf("Verifying method %s.%s\n", pstMethod->pstClass->uidName, pstMethod->uidName);

while ( rawIndex < numBytes) 
{
  int ins = (int) ((unsigned char) pbCode[ rawIndex]);
  struct byteCodeInfo info = infoTable[ ins ];
 
  if( (ins < 0) || (ins > 227))
     {
	eprintf("ins %i is out of range (> 226) at index %i\n", ins, rawIndex);
	assert( 3 == 4);
      }
 if( (info.extraBytes == 0) && (info.stackChange == 0) && (info.controlInstruction == 0))
	{
	 eprintf("NULL entry for instruction %i, %s.%s\n", ((unsigned char) pbCode[ rawIndex]), pstMethod->pstClass->uidName, pstMethod->uidName);
	return -1;
        }
	instructionIndex[instructionIndexIndex++] = rawIndex;

	

	if((info.extraBytes < 0) || (info.extraBytes > 6))
	{
	 eprintf("extra %i, index %i\n", info.extraBytes, rawIndex);
   	 assert(1 == 2);
	 return -2;
	}
	rawIndex += info.extraBytes + 1;
}



eprintf("There were %i instructions\n", instructionIndexIndex);

success = buildGraph( instructionIndexIndex, numBytes, instructionIndex, pbCode);


sys_free(instructionIndex);
return 0;
}


#include "graph.h"

int buildGraph( int numInstructions, int numBytes, int* instructionIndex, byte* pbCode)
{
  int flowIndex = 0;
  struct graph* g;

  g = GRAPH_create( numBytes );

  //Now we need to build a graph of code flow
  while( flowIndex < numInstructions) 
  {
    struct byteCodeInfo info = infoTable[ ((unsigned char) pbCode[ instructionIndex[flowIndex]])];

   //If this is a control instruction, we have to decode the target
   //otherwise it is just an edge to the next instruction
   if( info.controlInstruction == 0 )
    {
     int destinationInstruction = instructionIndex[ flowIndex + 1 ];

     if( destinationInstruction == -1)
	{
	 //it's a return instruction
	}
	else
	{

	     if((destinationInstruction < 0) || (destinationInstruction > instructionIndex[numInstructions - 1]))
	      return -1;

	     //This is not a control instruction 
	     if(GRAPH_addEdge(g, instructionIndex[flowIndex], destinationInstruction, info.stackChange ) != 0)
		return -3;
	}
    }
   else
    {
     int destinationInstruction = VERIFIER_getDestination( ((unsigned char) pbCode[ instructionIndex[ flowIndex ]]), instructionIndex[ flowIndex ], pbCode);

     if( destinationInstruction == -1)
	{
	 //it's a return instruction
	}
	else
	{
	     if((destinationInstruction < 0) || (destinationInstruction > instructionIndex[numInstructions - 1]))
	      return -1;
     
	     if(GRAPH_addEdge(g, instructionIndex[flowIndex], destinationInstruction, info.stackChange ) != 0)
		return -4;
	}
    }      
   flowIndex++; 
  }
return 0;
}



int VERIFIER_getDestination(unsigned char ins, int index, byte* pbCode)
{
  switch(ins)
  {
    case if_icmplt:
    case if_icmpne:
    case if_icmple:
    case if_icmpgt:
    case if_icmpge:
    case if_icmpeq:
    case if_acmpne:
    case if_acmpeq:
    case ifnull:
    case ifnonnull:
    case ifeq:
    case ifne:
    case iflt:
    case ifle:
    case ifgt:
    case ifge:
    case goto_:
     {
	int16 i16Temp;

	i16Temp =  pbCode[ index + 1 ] << 8;
	i16Temp += pbCode[ index + 2 ];
	return i16Temp;
     }	
    case ireturn:
    case lreturn:
    case freturn:
    case dreturn:
    case areturn:
    case return_:
     {
	//these don't branch anywhere, they exit the method
	return -1;
     }
    default:
	eprintf("Unknown instruction %i in VERIFIER_getDestination", ins);
  } 
  return -1;
}

#endif

