#include <config.h>
#include <stdlib.h>

#include <stdio.h>
#include <assert.h>


#ifdef VERIFIER

#include "graph.h"
#include "../interp.h"
#include "../disass.h"
#include "../stackmap/mapencoder.h"
#include "../opcodes.h"
#include "../stackmap/stackmap.h"
#include "../sys_linux_host/wrappers.h"

#ifdef KISSME_LINUX_HOST
#include <stdio.h>
#include <stdlib.h>
 #define eprintf(format, args...) fprintf(stderr, format, ## args)
#endif


struct graph* GRAPH_create(int numNodes) 
{

  struct graph* ret = (struct graph*) sys_malloc( sizeof(struct graph));

    if(ret == NULL)
      return NULL;

  ret->numNodes = numNodes;
  ret->edges = (int*) sys_malloc( (numNodes * numNodes) * sizeof(int));

  if(ret->edges == NULL)
    {
      sys_free(ret);
      return NULL;
    }

  return ret;
}

int GRAPH_destroy(struct graph* g) 
{
  if(g != NULL)
    {
      sys_free( g->edges );
      sys_free( g );
      return 0;
    }
  else 
    return -1;
}

int GRAPH_getEdge(struct graph* g, int from, int to) 
{
  if( (from > g->numNodes) || (to > g->numNodes))
    {
      return -1;
    }
  return g->edges[from * g->numNodes + to];
}

int GRAPH_addEdge(struct graph* g, int fromNode, int toNode, int edgeType) 
{
  if( (fromNode > g->numNodes) || (toNode > g->numNodes))
    {
      return -1;
    }
  else
    g->edges[fromNode * g->numNodes + toNode] = edgeType;
  return 0;
}

int GRAPH_print(struct graph* g) 
{
  
  int i, j;
  
  for(i = 0; i < (g->numNodes);i++)
    for(j = 0; j < (g->numNodes);j++)
      if( g->edges[i * g->numNodes + j] != 0 ) 
	{
	  eprintf("Edge from %i to %i of type ", i, j);
	  STACKMAP_printStackOp( stderr, g->edges[i * g->numNodes + j]);
	}
  return 0;
}

#endif
