#include <config.h>

#include <stdio.h>
#include <assert.h>

#include "../interp.h"

#include "../opcodes.h"
#include "../jutils.h"
//#include "../llist.h"

#include "../jni.h"
#include "../newobject.h"
#include "svetlana.h"

#include "assemble.h"


#include "control.h"

/* This method returns a pointer to a block of code that can be called in place of interpreting the bytecodes of this method */



#ifdef USE_FAST_GENERATOR 
void* SVETLANA_createOptimisedMethod(JNIEnv* env, tMethod* pstMethod, byte* pCode, int length) {

    {
    	jclass clazz  = (*env)->FindClass(env, "cavalry/translator/FastGenerator");
	exit(22);
	if(clazz)
	    {
		jmethodID methodID = (*env)->GetMethodID(env, clazz, "compileMethod", "([BIILjava/lang/String;Z)[B");
		tARREF pstArrayTemp;
		tARREF pstArrayMachineCode;
		jstring methodName;
		jstring methodSig;
		jobject FastGenerator;
		int i;

		assert(methodID);

		pstArrayTemp = INTERP_NewArray(env, T_BYTE, length, NULL, NULL);
		for(i = 0; i < length;i++)
		    {
			((byte*) ADEREF(pstArrayTemp)->pvElements)[i] = pCode[i];
		    }

		FastGenerator = INTERP_NewObjectFromName(env, "cavalry/translator/FastGenerator");

		methodName = INTERP_NewStringFromAsciz(env,  pstMethod->uidName );
		methodSig = INTERP_NewStringFromAsciz(env, pstMethod->uidSignature );
 
		
		pstArrayMachineCode = (tARREF) (*env)->CallObjectMethod (env, FastGenerator,  methodID, pstArrayTemp, (int) env, (int) pstMethod->pstClass, methodName, JNI_TRUE);

		if( (*env)->ExceptionOccurred(env) )
		    {
			(*env)->ExceptionDescribe(env);
			(*env)->ExceptionClear(env);
		    }
		//If we can't compile it
		if(pstArrayMachineCode == NULL)
		    return NULL;


		//		fprintf(stderr, "Got machine code %x\n", pstArrayMachineCode);
		//		(*env)->CreateLocalRef((tJNIData*) env, pstArrayMachineCode);
		//	         (*env)->NewGlobalRef( env, (jobject) pstArrayMachineCode);
		
{
		    int i = 0;

		    for(i = 0; i < ADEREF(pstArrayMachineCode)->i32Number;i++)
		    {
			fprintf(stderr, "%i %x\n", i, ((byte*) ADEREF(pstArrayMachineCode)->pvElements)[i]);
		    }
		    }

			{
			    void* ptr = (void*) malloc( ADEREF(pstArrayMachineCode)->i32Number );
			    assert(ptr);
			    memcpy( ptr, ADEREF(pstArrayMachineCode)->pvElements, ADEREF(pstArrayMachineCode)->i32Number);
			    return ptr;
			}

			//		return ADEREF(pstArrayMachineCode)->pvElements;
	    }
	else
	    {
		fprintf(stderr, "Couldn't find class cavalry/translator/FastGenerator\n");
		return NULL;
	    }

    }
}

#else

#error Narrrgh

#endif //FAST_GEN








