/*
 * store.h
 *
 * Definitions for store.
 *
 */

#ifndef __STORE_H__
#define __STORE_H__

#include "stdtypes.h"

typedef int32 PID;


/* functions for opening and closing stores */

int STORE_OpenStore (const char* storename);
int STORE_NewStore (const char* storename);
void STORE_CloseStore (void);

/* functions for getting and setting the root object's PID */

PID STORE_GetRootPID(void);
void STORE_SetRootPID(PID pid);

/* functions for manipulating objects within a store */

int STORE_GetObjectSize (PID pid);
void STORE_LoadObject (PID pid, char* obj);
void STORE_UpdateObject (PID pid, void* obj);
PID STORE_NewObject (int objsize);




/* Stuff for the PJSL store, I have broken the #ifdef stuff so that PID will be declared twice  if PJSL is used */

/* typedef for Persistent IDentifier */
#ifdef PJSLREAL

#include "pjsl.h"
typedef pjsl_pid_t PID;


#ifdef PJSLCOMPAT
#ifdef OLDPJSLCOMPAT
#include <stdio.h>

typedef unsigned int uint;
typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef struct{unsigned int hi; unsigned int lo;} ulonglong;

typedef struct
{
  FILE* dataFile;
  int32 firstAvail;
} pjsl_t;

typedef enum
{
  pjsl_error,
  pjsl_ok
} pjsl_err_t;

typedef PID pjsl_pid_t;
typedef unsigned char pjsl_kind_t;
typedef unsigned char pjsl_regime_t;
typedef unsigned int pjsl_partition_t;
typedef size_t pjsl_size_t;
typedef unsigned int pjsl_offset_t;
typedef int pjsl_desc_t;
typedef int pjsl_obj_info_t;

typedef enum
{
  pjsl_kind_iter_ok,
  pjsl_kind_iter_dirty_page,
  pjsl_kind_iter_stop,
  pjsl_kind_iter_abort
} pjsl_kind_iter_status_t;
typedef pjsl_kind_iter_status_t (pjsl_get_refs_callback_t) (pjsl_pid_t* pid, void* state);

typedef pjsl_err_t (pjsl_kind_allocate_t) (pjsl_t* pjsl, pjsl_size_t size, pjsl_obj_info_t info, pjsl_pid_t* pid);
typedef pjsl_err_t (pjsl_kind_first_write_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_size_t size, pjsl_obj_info_t info, uchar* source);
typedef pjsl_err_t (pjsl_kind_fetch_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_obj_info_t info, uchar* destination);
typedef pjsl_err_t (pjsl_kind_partial_fetch_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, pjsl_size_t size, pjsl_obj_info_t info, uchar* destination);
typedef pjsl_err_t (pjsl_kind_get_info_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_obj_info_t* info);
typedef pjsl_err_t (pjsl_kind_update_all_t) (pjsl_t* pjsl, pjsl_pid_t pid, uchar* source);
typedef pjsl_err_t (pjsl_kind_update_ref_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, pjsl_pid_t newPid);
typedef pjsl_err_t (pjsl_kind_update_1_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, uchar newValue);
typedef pjsl_err_t (pjsl_kind_update_2_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, ushort newValue);
typedef pjsl_err_t (pjsl_kind_update_4_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, uint newValue);
typedef pjsl_err_t (pjsl_kind_update_8_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, ulonglong newValue);
typedef pjsl_err_t (pjsl_kind_range_update_ref_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, pjsl_size_t num, pjsl_pid_t* source);
typedef pjsl_err_t (pjsl_kind_range_update_1_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, pjsl_size_t num, uchar* source);
typedef pjsl_err_t (pjsl_kind_range_update_2_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, pjsl_size_t num, ushort* source);
typedef pjsl_err_t (pjsl_kind_range_update_4_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, pjsl_size_t num, uint* source);
typedef pjsl_err_t (pjsl_kind_range_update_8_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, pjsl_size_t num, ulonglong* source);
typedef pjsl_err_t (pjsl_kind_get_refs_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset, pjsl_get_refs_callback_t* callback, void* state);
typedef pjsl_err_t (pjsl_kind_finaliser_t) (pjsl_t* pjsl, pjsl_pid_t pid, pjsl_offset_t offset);

typedef struct
{
  pjsl_kind_allocate_t*      allocate;
  pjsl_kind_first_write_t*   firstWrite;
  pjsl_kind_fetch_t*         fetch;
  pjsl_kind_partial_fetch_t* partialFetch;
  pjsl_kind_get_info_t*      getInfo;
  pjsl_kind_update_all_t*    updateAll;
  pjsl_kind_update_ref_t*    updateRef;
  pjsl_kind_update_1_t*      update1;
  pjsl_kind_update_2_t*      update2;
  pjsl_kind_update_4_t*      update4;
  pjsl_kind_update_8_t*      update8;
  pjsl_kind_range_update_ref_t* rangeUpdateRef;
  pjsl_kind_range_update_1_t*   rangeUpdate1;
  pjsl_kind_range_update_2_t*   rangeUpdate2;
  pjsl_kind_range_update_4_t*   rangeUpdate4;
  pjsl_kind_range_update_8_t*   rangeUpdate8;
  pjsl_kind_get_refs_t*      getRefs;
  pjsl_kind_finaliser_t*     finaliser;
} pjsl_kind_ops_t;

pjsl_t* pjsl_new(void);
pjsl_err_t pjsl_create(pjsl_t* pjsl, char* name, uint bufferSize, uint maxParts, uint maxSize, char* appVersion);
pjsl_err_t pjsl_open(pjsl_t* pjsl, char* name, uint bufferSize);
pjsl_err_t pjsl_close(pjsl_t* pjsl);
pjsl_err_t pjsl_objInspect(pjsl_t* pjsl, pjsl_pid_t pid, pjsl_kind_t* kind, pjsl_regime_t* reg, pjsl_size_t* size);
pjsl_err_t pjsl_setPersistentRoot(pjsl_t* pjsl, pjsl_pid_t pid);
pjsl_err_t pjsl_getPersistentRoot(pjsl_t* pjsl, pjsl_pid_t* pid);

pjsl_kind_ops_t** kindDispatchTable;

#define PJSL_KIND_OP(reg, kind, op) (*(kindDispatchTable[(reg)][(kind)].op))

#ifdef PJSLREAL
#define KIND PJSL_SMALL_SCALAR_KIND
#else
#define KIND 0
#endif

extern pjsl_t* STORE_Store;
#endif

#include "pjsl.h"
extern pjsl_t* STORE_Store;

#ifdef PJSLREAL
#define KIND PJSL_SMALL_SCALAR_KIND
#else
#define KIND 0
#endif

#endif
#endif
#endif




