/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#ifdef KISSME_LINUX_KERNEL

#include <linux/module.h>
#include <linux/types.h>
#include <linux/file.h>
#include <linux/stat.h>
#include <linux/fcntl.h>
#include <asm/uaccess.h>
#include <linux/fs.h>
#include "sys_linux_kernel/file.h"
#endif

#ifdef KISSME_LINUX_USER
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <signal.h>
#include <string.h>
#include <pthread.h>
#endif

#include "../lib/indigenous/java.lang/VMSystem.h"
#include "../lib/indigenous/java.lang/VMClassLoader.h"
#include "../lib/indigenous/java.lang/Class_Reflection.h"
#include "threads_native.h"
#include "interp.h"
#include "jni.h"
#include "interp_methods.h"
#include "classfile_methods.h"
#include "garbage.h"
#include "garbage2.h"
#include "newobject.h"
#include "methodstacks.h"
#include "threadinfo.h"

#include "startup.h"
#include "oom_exception_object.h"

#ifdef TEASEME
extern volatile int iSystemHeapDestroyed; //flag indicating that the system heap has been free'ed
#endif
extern int use_persistent_store;
extern int canStartOptimising; //for the JIT
extern volatile int totalThreadsInSystem; //we count all threads that are created and destroyed
extern tClassLoaderTuple* pstObjectType; // this can be globally used to get the type for object
extern tClassLoaderTuple* pstStringType; // this can be globally used to get the type for string
extern tClassLoaderTuple* pstClassType; // this can be globally used to get the type for class

#ifdef TEASEME
#ifdef KISSME_LINUX_KERNEL
int run_thread(void* arg);
#else
void* run_thread(void* arg);
#endif
#include "../lib/indigenous/jos.system/processes.h"
#endif

jobject OOMExceptionObject = NULL;
int INTERP_FirstThreadRunning;
tAllocatorHeap* system_heap;

#ifdef TEASEME
char** CLASSFILE_ppszClassPaths = NULL; 
uint16 CLASSFILE_u16NumClassPaths = 0;
#endif

int STARTUP_startup(char* pszMainClass, char* pszStoreName, int argc, char** argv, int argsused) {

  int32 i32MainStackPlace;
  tStackFrame* pstFrame;
  tClassLoaderTuple* pstMainClass;
  tMethod* pstMainMethod;
  tOBREF hMainThread;
  tOBREF pstExOb;

  tJNIData* pstJNIData;
  tARREF pstArgArray;
  JNIEnv* jni_env;

  int i;
  tThreadNode* node;

#ifdef TEASEME
  tClassLoaderTuple* tclass;
  tAllocatorHeap* pstHeap; //the heap for the 'init' process
  struct run_thread_args* targs;
#endif

#ifndef TEASEME
#ifdef USE_DISTRIBUTED_STORE
	/* We'll open the store on demand*/
#else

  #ifdef PERSIST
  // open the store here now rather than via a Java call 

            //No, only open the store if -store was specified  
if( use_persistent_store )
  {
  if (STORE_OpenStore(pszStoreName) == 0)
  {
    STORE_NewStore(pszStoreName);
  }
  }
  #endif
#endif
#endif

#ifdef TEASEME
  CLASSFILE_ppszClassPaths = sys_malloc(sizeof(char*) * 3);
  CLASSFILE_u16NumClassPaths = 3; 
  CLASSFILE_ppszClassPaths[0] = "/home/jewel/teaseme/cvs/classes";
  CLASSFILE_ppszClassPaths[1] = "/home/jewel/kissme/cvs/classes";
  CLASSFILE_ppszClassPaths[2] = "/home/jewel/java/cvsclasspath/classpath";
//  CLASSFILE_ppszClassPaths[1] = "/usr/share/teaseme/classes";

  eprintf(" ----------------------------------------\n teaseme JVM loaded (tid %x %i)\n", (int) sys_current_thread(), (int) sys_current_thread());
  eprintf("Using class path: %s\n",   CLASSFILE_ppszClassPaths[0]);
  eprintf("and class path: %s\n",   CLASSFILE_ppszClassPaths[1]);
  eprintf("and class path: %s\n",   CLASSFILE_ppszClassPaths[2]);

  iSystemHeapDestroyed = 0;
#endif

  OOMExceptionObject = NULL;

  CLASSFILE_Init();

  totalThreadsInSystem = 0;

  sys_mutex_provider_init();
  sys_condition_provider_init();

  THREAD_Init();
#ifdef TEASEME
  JOSPROCESS_Init();
#else
  system_heap = GARBAGE_Init();  
#endif
  JNI_zeroJNITable();

  node = THREADINFO_CreateNewNodeForThread(sys_current_thread(), &i32MainStackPlace);
  THREADINFO_addThreadNodeToList(node);

  THREADINFO_IncrementThreadCount();

  /* create this thread's JNIData structure */
  java_lang_Thread__createJNIData(NULL, NULL);
  pstJNIData = JNI_getJNIData( sys_current_thread());
#ifdef TEASEME
  system_heap =  pstHeap = GARBAGE_Init();
  pstJNIData->pstHeap = pstHeap;
#else
  pstJNIData->pstHeap = system_heap;
#endif

  jni_env = &pstJNIData->functions;
  if(( pstClassType = CLASSFILE_FindOrLoad(jni_env, "java/lang/Class", NULL)) == NULL) //XXX Check the loading tuple
    {
      eprintf("Could not find java/lang/Class\n");
      shutdown_machine(NULL, 0 , -1);
      return -2;
    }
  if(( pstObjectType = CLASSFILE_FindOrLoad(jni_env,"java/lang/Object", NULL)) == NULL)
    {
      eprintf("Could not find java/lang/Object\n");
      shutdown_machine(NULL, 0 , -1);
      return -2;
    }
  if(( pstStringType = CLASSFILE_FindOrLoad(jni_env,"java/lang/String", NULL)) == NULL)
    {
      eprintf("Could not find java/lang/String\n");
      shutdown_machine(NULL, 0 , -1);
      return -2;
    }

  /* initialise JNI */
  JNI_Init(jni_env); //Note that this loads java/lang/Class

  if(java_lang_VMClassLoader_makePrimitiveTypes(jni_env) != 0)
    {
      eprintf("An error occurred creating the primitive types and their classes. This is an internal JVM error, please contact the authors of the program\n");
      return shutdown_machine(NULL, 0, -7);
    }

  assert(CLASSFILE_FindOrLoad(jni_env, "java/lang/Thread", pstClassType));
  assert(CLASSFILE_FindOrLoad(jni_env, "java/lang/NullPointerException", pstClassType));

  INTERP_FirstThreadRunning = 1;

  if(( CLASSFILE_FindOrLoad(jni_env,"java/lang/System", NULL)) == NULL)
    {
      eprintf("Could not find java/lang/System\n");
      shutdown_machine(NULL, 0 , -1);
      return -2;
    }

#ifdef TEASEME
  targs = sys_malloc(sizeof(struct run_thread_args));

  targs->pstOrigHeap = pstHeap;
  targs->pstNewHeap = pstHeap;
  targs->pstJNIData = pstJNIData;
  if((  targs->className = INTERP_NewStringFromAsciz(jni_env, "teaseme/system/init")) == NULL)
     return -1;
  if((targs->args = INTERP_NewArray(jni_env, T_OBJECT, 0, "java/lang/String", pstClassType)) == NULL)
    return -2;

 if(1)
  {
    jclass tgClazz;
    jmethodID methodID;
    jstring cstring = INTERP_NewStringFromAsciz(jni_env, "init");
    assert(cstring);

    tgClazz = (*jni_env)->FindClass(jni_env, "java/lang/ThreadGroup");
    assert(tgClazz);
    methodID  = (*jni_env)->GetMethodID(jni_env, tgClazz, "<init>", "(Ljava/lang/String;)V");
    assert(methodID);
    targs->threadGroup = (*jni_env)->NewObject(jni_env,  tgClazz, methodID, cstring);
    
    if(!targs->threadGroup)
      return -3;
  }

if(1)
  {
    jclass tClazz;
    jmethodID methodID;
    jstring cstring = INTERP_NewStringFromAsciz(jni_env, "initThread");
    assert(cstring);
    tClazz = (*jni_env)->FindClass(jni_env, "java/lang/Thread");
    assert(tClazz);
    methodID = (*jni_env)->GetMethodID(jni_env, tClazz, "<init>", "(Ljava/lang/ThreadGroup;Ljava/lang/String;)V");
    assert(methodID);
    targs->threadObject = (*jni_env)->NewObject(jni_env, tClazz, methodID, targs->threadGroup, cstring);
    
    if(!targs->threadObject)
      return -4;
  }

if(1)
  {
    jclass jClazz;
    jmethodID methodID;

    jClazz = (*jni_env)->FindClass(jni_env, "teaseme/system/servers/process/JOSProcess");
    assert(jClazz);
    methodID = (*jni_env)->GetMethodID(jni_env, jClazz, "<init>", "(I)V");
    assert(methodID);
    targs->josProcessObject = (*jni_env)->NewObject(jni_env, jClazz, methodID, (jint) pstHeap);
    
    if(!targs->josProcessObject)
      return -5;
  }
#endif

#ifndef GARBAGE_GENERATIONAL
  #ifdef PERSIST
  RPOT_Init();
  CLASSFILE_FindOrLoad(jni_env, "plava/PStore", pstClassType);
  #endif
#endif



#ifdef TEASEME
  eprintf(" Starting main thread\n");
  //Start the main thread
#ifdef KISSME_LINUX_KERNEL
  kernel_thread( &run_thread, (void*) targs, 0);
#else
  #ifdef KISSME_LINUX_USER
  {
    pthread_t id;
    eprintf("Starting thread now\n");
    assert(pthread_create(&id, NULL, &run_thread, (void*) targs) == 0);
    
  }
  #else
  kinterface->kthread_create(&run_thread, (void*) targs, 16, 0);
  #endif
#endif

  totalThreadsInSystem++;
#ifdef KISSME_LINUX_USER
    while(iSystemHeapDestroyed == 0)
      {
	      #ifdef HAVE_PTHREAD_YIELD
	      pthread_yield();
	      #endif
      }
#endif
#endif
    if(STARTUP_createOOMExceptionObject(jni_env) != 0)
      {
	return -6;
      }

#ifdef USE_JAVA_CLASSLOADER
 setBootstrapped();
#endif

#ifndef TEASEME
 /* Construct a thread object for the main thread */
 hMainThread = INTERP_ConstructMainThread(jni_env);
 assert(hMainThread);

  pstMainClass = CLASSFILE_FindOrLoad(jni_env, pszMainClass, pstClassType);
  if (pstMainClass == NULL)
  {
    INTERP_printStackTrace(jni_env, (*jni_env)->ExceptionOccurred(jni_env));
    fprintf(stderr, "Specified main class %s not found.\n", pszMainClass);
    shutdown_machine(NULL, 1, 1);
    return 1;
  }
  pstMainMethod = CLASSFILE_FindMethod(jni_env, pstMainClass, "main", "([Ljava/lang/String;)V");
  if (!pstMainMethod)
  {
    fprintf(stderr, "Method main(String[]) not found in class %s.\n", pszMainClass);
   shutdown_machine(NULL, 1, 2);
    return 1;
  }

  /* handle command-line arguments */
  pstArgArray = INTERP_NewArray(jni_env, T_OBJECT, argc - argsused, "java/lang/String", pstClassType);
  for (i = argsused; i < argc; i++)
  {
    ((tOBREF*) ADEREF(pstArgArray)->pvElements)[i - argsused] = INTERP_NewStringFromAsciz(jni_env, argv[i]);
  }

  totalThreadsInSystem++;


 #ifdef ENABLE_SVETLANA
    canStartOptimising = 0;
    /* ------------------------------------------------ */
    /* Ok here somewhere we have to start up the optimiser*/
    {
	jclass clazz = (*jni_env)->FindClass(jni_env, "cavalry/translator/FastGenerator");
	
	if(clazz)
	    {
		jmethodID methodID = (*jni_env)->GetStaticMethodID(jni_env, clazz, "prepareForOperation", "()Z");
		jboolean ret;

		assert(methodID);

		pstFrame = InitialStackFrame(methodID, NULL, NULL, system_heap);

		THREADINFO_SetNodeInfo(node, hMainThread, &i32MainStackPlace);

		fprintf(stderr," calling optimiser bootstrap in startup.c\n");  
		assert(THREADINFO_addInitialStackFrameToNode( node, pstFrame ) == 0);
		pstExOb = Interpret(jni_env, pstFrame, 1);
		assert(THREADINFO_removeInitialStackFrameFromNode( node, pstFrame ) == 0);
		if (pstExOb)
		  {
		    INTERP_printStackTrace(jni_env, (*jni_env)->ExceptionOccurred(jni_env));
		  }

		if(pstExOb == NULL)
		    {
		    fprintf(stderr," did optimiser bootstrap in startup.c\n");
		    canStartOptimising = 1;
		    }
		else
    		    fprintf(stderr," FAILED  optimiser bootstrap in startup.c\n");
		if( (*jni_env)->ExceptionOccurred(jni_env) )
		    {
			(*jni_env)->ExceptionDescribe(jni_env);
			(*jni_env)->ExceptionClear(jni_env);
		    }
	    }
    fprintf(stderr," finished did optimiser bootstrap in interp.c\n");
    }
    /* ------------------------------------------------ */
#endif


  /* We create a frame for the static main method, it has no pstNewObject because it is static */
  pstFrame = InitialStackFrame(pstMainMethod, NULL, (int32*) &pstArgArray, system_heap);

  THREADINFO_SetNodeInfo(node, hMainThread, &i32MainStackPlace);
  
  assert(THREADINFO_addInitialStackFrameToNode( node, pstFrame ) == 0);
  pstExOb = Interpret(jni_env, pstFrame, 1);
  assert(THREADINFO_removeInitialStackFrameFromNode( node, pstFrame ) == 0);
  if (pstExOb)
  {
    INTERP_printStackTrace(jni_env, (*jni_env)->ExceptionOccurred(jni_env));
  }
  else
  {
    #ifdef DEBUG
    fprintf(stderr, "Interpreter exitted normally\n");
    #endif
  }

  node->isTerminated = 1;
  i32MainStackPlace = 22; //stop this being optimised away
  /* ok, now shutdown the machine */
  return shutdown_machine(pstExOb, 0, 0);
#endif

#ifdef TEASEME
  i32MainStackPlace = 0x3839272; //stop optimisation
  eprintf(" STARTUP_startup returning 0 (threads %i)\n",   totalThreadsInSystem);
  return 0;
#endif
}
