#include <config.h>
/* 
 * @doc MODULE 
 * @module natives.c | 
 * 
 * This file contains an array of native methods that get added to classes 
 * when they are initialised. It also contains the function that adds the 
 * native methods to the classes. 
 * 
 */ 
 
#include <stdlib.h> 
#include <string.h> 
#include <assert.h> 
#include "jni.h" 
#include "natives.h" 

#include "global.h" 


//JEPS stuff


#ifdef NATIVE_THREADS
jobject java_lang_Thread_nativeCurrentThread(JNIEnv* env, jclass thisclass);
#endif


#include "../extra/classpath_missing.h"

#include "../lib/classpath/java.lang/java_lang_Object.h" 
#include "../lib/classpath/java.io/java_io_ObjectInputStream.h"
#include "../lib/indigenous/java.lang/VMObject.h" 
#include "../lib/indigenous/java.lang/java_lang_Class.h"
#include "thread.h" 
#include "../lib/indigenous/java.lang/Thread.h" 

#include "java_lang_System.h"
#include "../lib/indigenous/java.lang/UnixProcess.h"
#include "../lib/indigenous/java.lang/VMSystem.h"
#include "../lib/indigenous/java.lang/VMClassLoader.h"
#include "../lib/indigenous/java.lang/Throwable.h" 

#include "../lib/indigenous/java.lang.reflect/Array.h" 
#include "../lib/indigenous/java.lang.reflect/Constructor.h" 
#include "../lib/indigenous/java.lang.reflect/Method.h" 

#include "../lib/indigenous/java.util/java_util_TimeZone.h"
#include "../lib/classpath/java_lang_Float.h"
#include "../lib/classpath/java_lang_Double.h" 
#include "../lib/classpath/java.lang/java_lang_Math.h"


#include "../lib/indigenous/jeps/EtherHostDriver.h" 

//Reflection stuff

#include "../lib/indigenous/java.lang.reflect/java_lang_reflect_Field.h"

#ifdef CLASSPATH_BIGINTEGER
#include "../lib/classpath/java.math/java_math_BigInteger.h"
#endif

#ifdef CLASSPATH_FILE_IO

//Stuff from classpath
#include "../lib/classpath/java.io/javaio.h"
#include "../lib/classpath/java.io/java_io_FileDescriptor.h"
#include "../lib/classpath/java.io/java_io_File.h"
#include "../lib/classpath/java.io/java_io_FileInputStream.h"
#include "../lib/classpath/java.io/java_io_FileOutputStream.h"
#include "../lib/classpath/java.io/java_io_ObjectOutputStream.h"
#include "../lib/classpath/java.io/java_io_RandomAccessFile.h"
#else

#include "../lib/indigenous/java.io/FileDescriptor.h"
#include "../lib/indigenous/java.io/FileOutputStream.h"
#include "../lib/indigenous/java.io/FileInputStream.h"
#include "../lib/indigenous/java.io/File.h"

#endif

#include "../lib/indigenous/java.util/ResourceBundle.h"
#include "../lib/indigenous/java.lang/VMSecurityManager.h"
//Jewel
#ifdef NETWORKING
#ifdef CLASSPATH_NETWORKING
#include "../lib/classpath/java.net/java_net_PlainSocketImpl.h"
#include "../lib/classpath/java.net/java_net_InetAddress.h"
#include "../lib/classpath/java.net/java_net_PlainDatagramSocketImpl.h"

#endif 
#endif

#include "../lib/indigenous/jos.system/machine.h"    
//#include "../indigenous/jos.system.video/RawVideo.h"    
#include "../lib/indigenous/java.lang/java_lang_Runtime.h"

#ifdef CURSES_CONSOLE
#include "../lib/curses/teaseme_console_curses_CursesConsole.h"
#endif

#ifdef GTKPEER
#include "../lib/classpath/awt/gnu_java_awt_image_GdkPixbufDecoder.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GdkFontMetrics.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GdkGraphics.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkButtonPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkCanvasPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkCheckboxMenuItemPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkCheckboxPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkChoicePeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkClipboard.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkComponentPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkFileDialogPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkFramePeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkImagePainter.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkLabelPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkListPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkMainThread.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkMenuBarPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkMenuItemPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkMenuPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkPanelPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkPopupMenuPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkScrollPanePeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkScrollbarPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkTextAreaPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkTextComponentPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkTextFieldPeer.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkToolkit.h"
#include "../lib/classpath/awt/gnu_java_awt_peer_gtk_GtkWindowPeer.h"
#endif 

#ifdef PYGMALION
#include "../lib/indigenous/pygmalion/Pygmalion.h"
#include "../lib/indigenous/coltrane/Coltrane.h"
#endif

#include "../lib/indigenous/plava/PStore.h"

#ifdef ENABLE_SVETLANA
#include "svetlana/jni_methods.h"
#endif

#ifdef JOSPROCESS
#include "../lib/indigenous/teaseme.system/System.h"    
#include "../lib/indigenous/teaseme.system.servers.process/JOSProcess.h"    
#include "../lib/indigenous/teaseme.system.servers.process/ProcessServer.h"    
 #endif
 
tNewNativeLookup pstNewNativeLookupTable[] = 
{
  #include "java_lang_Float_natives.h"
  #include "java_lang_Object_natives.h"
  #include "java_lang_VMObject_natives.h"
  #include "java_lang_VMSystem_natives.h"
  #include "java_lang_Class_natives.h"
  #include "java_lang_VMClassLoader_natives.h"
  #include "java_lang_Thread_natives.h"
  #include "java_lang_System_natives.h"
  #include "java_lang_Runtime_natives.h"
  #include "java_lang_Double_natives.h"
  #include "java_lang_Throwable_natives.h"
  #include "java_lang_Math_natives.h"
  #include "java_lang_UnixProcess_natives.h"

  #include "java_math_BigInteger_natives.h"
  #include "java_lang_VMSecurityManager_natives.h"
  #include "java_util_ResourceBundle_natives.h"
  #include "java_util_TimeZone_natives.h"
  #include "java_io_FileDescriptor_natives.h"
  #include "java_io_File_natives.h"
  #include "java_io_FileInputStream_natives.h"
  #include "java_io_FileOutputStream_natives.h"
  #include "java_io_RandomAccessFile_natives.h"

  #include "java_io_ObjectOutputStream_natives.h"
  #include "java_io_ObjectInputStream_natives.h"

#ifdef KISSME_LINUX_USER
  #include "java_net_InetAddress_natives.h"
  #include "java_net_PlainDatagramSocketImpl_natives.h"
  #include "java_net_PlainSocketImpl_natives.h"
#endif

  #include "java_lang_reflect_Method_natives.h"
  #include "java_lang_reflect_Array_natives.h"
  #include "java_lang_reflect_Constructor_natives.h"
  #include "java_lang_reflect_Field_natives.h"

  #include "plava_PStore_natives.h"

#ifdef ENABLE_SVETLANA
  #include "cavalry_natives.h"
#endif
#ifdef CURSES_CONSOLE
#include "teaseme_console_curses_CursesConsole_natives.h"
#endif
#ifdef GTKPEER
#include "gtkpeer_natives.h"
#endif
  #include "jos_system_machine_natives.h"
  #ifdef TEASEME
  #include "teasme_system_servers_process_ProcessServer_natives.h"
  #endif
  /* end */ 
  {"---","end of list","---", NULL} 
};

int32 i32NumTableEntries = sizeof(pstNewNativeLookupTable) / sizeof(pstNewNativeLookupTable[0]); 

 
