/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Miscellaneous functions needed by the JVMDI */

#include <config.h>
#include "garbage/public_methods.h"
#include "jvmdi.h"

#ifdef TEASEME_JVMDI

jvmdiError
GetLoadedClasses(jint *classCountPtr, jclass **classesPtr)
{
}

jvmdiError
GetClassLoaderClasses(jobject initiatingLoader, jint *classCountPtr, jclass **classesPtr)
{
}

jvmdiError
GetVersionNumber(jint *versionPtr)
{
  if(versionPtr == NULL)
    return JVMDI_ERROR_NULL_POINTER;
  *versionPtr = (1 << 16) | 0; //1.0
  return JVMDI_ERROR_NONE;
}

jvmdiError
GetCapabilities(JVMDI_capabilities *capabilitiesPtr)
{
  capabilitiesPtr->can_watch_field_modification = 0;
  capabilitiesPtr->can_watch_field_access = 0;
  capabilitiesPtr->can_get_bytecodes = 0;
  capabilitiesPtr->can_get_synthetic_attribute = 0;
  capabilitiesPtr->can_get_owned_monitor_info = 0;
  capabilitiesPtr->can_get_current_contended_monitor = 0;
  capabilitiesPtr->can_get_monitor_info = 0;
  return JVMDI_ERROR_NONE;
}

#endif





