/*****************************************************************************
******************************************************************************
*
*        file : irdeto.h
*
* Description : This file defines all common typedefs for all projects
*                written in C by or for IREDETO.
*
*       NOTES : 1. Is target independent, except for the float types below
*                     DOUBLE and FLOAT, these are normally target dependant.
*       NOTES : 2. For PC __WIN32__ platform (or any windows platform), the
*                     types clash with pre-defined types in <windows.h>. We have
*                     to thus define them according to what is in <windows.h>,
*                     so they are not strictly target independant
*
*      Author : Allen Rossouw.
*
*      Status : Version 1.00
*
*     History :
*
*        $Log : irdeto.h $
*
*   Copyright : IRDETO 1994.  (c)
*
******************************************************************************
*****************************************************************************/

#ifndef _IRDETO_H_
#define _IRDETO_H_

/************************************
*                                   *
*  all typdef's for new data types  *
*                                   *
************************************/

#ifdef __WIN32__

#ifndef __WINDOWS_H

#ifdef STRICT
typedef signed long         LONG;
#else
#define LONG long
#endif
/* This must match whatever's in <windows.h> */
typedef int                 BOOL;
typedef unsigned char       BYTE;
#ifdef STRICT
typedef signed long         LONG;
#else
#define LONG long
#endif
#ifndef _TCL
typedef  void               VOID;    /*  range :  n.a.                      */
#endif
typedef unsigned short      WORD;
#endif /*!__WINDOWS_H*/

#else /*!__WIN32__*/

typedef  unsigned char   BOOL;    /*  range :  0 to 1                    */
typedef  unsigned char   BYTE;    /*  range :  0 to 255                  */
typedef  signed long     LONG;    /*  range :  -2147483648 to 2147483647 */
#ifndef _TCL
typedef  void            VOID;    /*  range :  n.a.                      */
#endif
typedef  unsigned short  WORD;    /*  range :  0 to 65535                */

#endif /*__WIN32__*/

typedef  double          DOUBLE;  /*  target dependent                   */
typedef  float           FLOAT;   /*  target dependent                   */
typedef  char            CHAR;    /*  range :  0 to 255 or -128 to 127   */
typedef  signed char     SINT;    /*  range :  -128 to 127               */
typedef  unsigned long   ULONG;   /*  range :  0 to 4294967295           */

#ifdef __WIN32__

#ifndef __WINDOWS_H
/*This must match <windows.h>*/
typedef  int             INT;     /* ### note this is not the same as other platforms */
#endif

#else /*!__WIN32__*/

typedef  signed short    INT;     /*  range :  -32768 to 32767           */

#endif /*__WIN32__*/


/************************************
*                                   *
*  all typdef's for pointer types   *
*                                   *
************************************/

#ifdef __WIN32__
#ifndef __WINDOWS_H
/* These must match <windows.h>. */
typedef  BOOL    *PBOOL;
typedef  BYTE    *PBYTE;
typedef  INT     *PINT;
typedef  DOUBLE  *PDOUBLE;
typedef  FLOAT   *PFLOAT;
typedef  LONG    *PLONG;
typedef  ULONG   *PULONG;
#ifndef _TCL
typedef  VOID    *PVOID;
#endif /*_TCL*/
typedef  WORD    *PWORD;

#endif /*!__WINDOWS_H*/

#else /*!__WIN32__*/

typedef  BOOL    *PBOOL;
typedef  BYTE    *PBYTE;
typedef  INT     *PINT;
typedef  DOUBLE  *PDOUBLE;
typedef  FLOAT   *PFLOAT;
typedef  LONG    *PLONG;
typedef  ULONG   *PULONG;
#ifndef _TCL
typedef  VOID    *PVOID;
#endif /*_TK*/
typedef  WORD    *PWORD;

#endif /*__WIN32__*/
typedef  CHAR    *PCHAR;
typedef  CHAR    *PSZ;
typedef  SINT    *PSINT;



/************************************
*                                   *
*  #define's for BOOL elements      *
*                                   *
************************************/

#ifdef __WIN32__
#ifndef __WINDOWS_H
/* These must match the definitions in <windows.h> */
#define FALSE               0
#define TRUE                1
#define  ON      1
#define  OFF     0

#endif /*!__WINDOWS_H*/
#else /*!__WIN32__*/

#define  TRUE    (BOOL) (1)
#define  FALSE   (BOOL) /*lint -e506 */ (!TRUE ) /*lint -restore */
#define  ON      1
#define  OFF     0

#endif /*__WIN32__*/

#endif        /* _IREDTO_H_ */
