/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * @doc MODULE
 * @module cplist.h |
 *
 * Types and prototypes for the class-pointer list.
 *
 */

#ifndef __CPLIST_H__
#define __CPLIST_H__

#include "classfil.h"
#include "uid.h"

/*
 * @doc TYPE
 * @struct tCPListElement |
 * The element type of the class-pointer list (really a binary tree). We need
 * to store the parent pointer so that we can use iteration to traverse the
 * tree in an in-order walk.
 *
 */

typedef struct tcplistelement
{
  tClass* pstClass;                /* @parm Pointer to class */
  struct tcplistelement* pstParent;/* @parm Pointer to parent element */
  struct tcplistelement* pstLeft;  /* @parm Pointer to left element */
  struct tcplistelement* pstRight; /* @parm Pointer to right element */
} tCPListElement;

/* function prototypes */
void CPLIST_Insert(tClass* pstClass);
tClass* CPLIST_Find(char* pszName);
tClass* CPLIST_UidFind(Uid uidName);
int CPLIST_IsEmpty(void);
void CPLIST_Empty(void);

void CPLIST_GoTop(void);
void CPLIST_Skip(void);
int CPLIST_IsMore(void);
tClass* CPLIST_GetCurrentClass(void);
char* CPLIST_GetCurrentName(void);

void CPLIST_ClearChanged(void);
int CPLIST_HasChanged(void);

void CPLIST_Dump();
void CPLIST_DumpNode( 
 tCPListElement* root, 
 int indent 
);

#endif /* #ifndef __CPLIST_H__ */

/* end of cplist.h */
