abstract class Protocol
{
  public static final int MAX_INTERFACES = 32;

  protected int protocolNumber;
  protected NetworkInterface[] interfaces;
  protected int nrInterfaces=0;
  
  Protocol()
  {
    interfaces = new NetworkInterface[MAX_INTERFACES];
  }

  public int getProtocolNumber()
  {
    return protocolNumber;
  }

  public boolean addInterface(NetworkInterface ni)
  { 
    if (nrInterfaces<MAX_INTERFACES)
     {
       interfaces[nrInterfaces++]=ni;
       return true;
     } else {return false;}
  }
  
  public boolean deleteInterface(NetworkInterface ni)
  {
    for (int i=0;i<nrInterfaces;i++)
    {
      if (interfaces[i]==ni)
      {
        interfaces[i]=interfaces[nrInterfaces];
	interfaces[nrInterfaces]=null;
	nrInterfaces--;
	return true;
      }
    }
    return false;
  }
  
/**************************************
 * This function will do all the work *
 **************************************/

  public abstract void Handle(Packet p);

/*********************************************
 * The variable "next" and the two following *
 * methods are used to implement a linked    *
 * list of protocols to traverse.            *
 * next == null => last protocol in list.    *
 *********************************************/
 
  protected Protocol next;
  
  public Protocol getNextProtocol() {return next;}
    
  public void setNextProtocol(Protocol np) {next=np;}  
};
