import java.io.*;

class IPPacket extends Packet
{
  public int HEADER_LEN=20;

  byte version;		// IP version (=4)
  byte hdr_length;	// in longs;
  byte tos;		// Type of service
  int length;		// packet lenght
  int id;		// datagram ID
  int fragment_offs;	// Fragment offset
  byte	ttl;		// Time To Live
  int checksum;		// Header checksum
  IPAddr dest; 		// The source hardware address (MAC)
  IPAddr src;  		// The destination hardware address

  IPPacket() {}

  IPPacket(byte[] raw)
  {
    data=raw;
    parse();
  }

  IPPacket(Packet p)
  {
    data=p.data;
    parse();
  }

  void parse()
  {
    hdr_length = (byte)(data[0] & 15);
    version = (byte)(data[0] >> 4);
    tos= data[1];
    length = (data[2] << 8) + data[3];
    id = (data[4] << 8) + data[5];
    fragment_offs = (data[6] << 8) + data[7];
    ttl = data[8];
    protocol = data[9]; 
    checksum = (data[10] << 8) + data[11];
    src = new IPAddr(data[12],data[13],data[14],data[15]);
    dest = new IPAddr(data[16],data[17],data[18],data[19]);
    if (checksum(hdr_length << 2)!=0)
    {
      System.out.println("IP Checksum failed!!!");
      System.out.println(checksum+"   "+checksum(hdr_length<<2));
    }
  }

  public String toString()
  {
//    return "Prot:"+protocol+"  "+src.toString()+"-->>"+dest.toString();
      return src.toString()+"->"+dest.toString()+"-"+version+"/"+hdr_length+"/"+tos+"/"+length+"/"+id+"/"+fragment_offs+"/"+ttl;
  }
  
  public void update() 
  { 
    data[0]=(byte)(hdr_length+(version << 4));
    data[1]=tos;
    data[2]=(byte)(length >> 8);
    data[3]=(byte)(length & 255);
    data[4]=(byte)(id >> 8);
    data[5]=(byte)(id & 255);
    data[6]=(byte)(fragment_offs >> 8);
    data[7]=(byte)(fragment_offs & 255);
    data[8]=ttl;
    data[9]=(byte)protocol;
    data[10]=0;data[11]=0;
    System.arraycopy(src.getData(),0,data,12,4);
    System.arraycopy(dest.getData(),0,data,16,4);
    checksum=checksum(hdr_length<<2); 	// Compute checksum.
    data[10]=(byte)(checksum >> 8);	// Store it.
    data[11]=(byte)(checksum & 255);
  }
};
