/************************************
 * Basic Ethernet interfacing class *
 * "Hosted" by linux with JNI       *
 *                                  *
 *		Ranieri Argentini   *
 ************************************/
 
class EtherHostDriver extends jos.platform.driver.Device 
		    implements NetworkInterfaceCard
{
  public final int MAX_PACKET_LEN=8000;

  private native int init(String intf);
  private native int read(byte[] buffer,int length);
  private native int write(byte[] buffer,int length);

  native void getHW(byte[] buffer);

  public HWAddr getHWAddr()
  {
    HWAddr hwaddr= new HWAddr();
    byte[] buffer= new byte[6];
    getHW(buffer);
    hwaddr.setData(buffer);
    return hwaddr;
  }
  
  static 
  {
    System.loadLibrary("ethhost");
  }
 
  public int init ()
  {
    return init("eth0");
  }

  public void write(EtherPacket ep)
  {
    write(ep.data,ep.data.length);
  }


  public EtherPacket read()
  {
    byte[] buffer = new byte[MAX_PACKET_LEN];
    int size = read(buffer,MAX_PACKET_LEN);
    if (size==-1)
      {
        return null;
      }
    else
      {
        // THis is dirty and slow. 
	byte[] buff= new byte[size];
	System.arraycopy(buffer,0,buff,0,size);
        return new EtherPacket(buff);
      }
  }
}
