/******************************
 * Adress Resolution Protocol *
 ******************************/

class ARP extends Protocol
{
  private ARPTableEntry firstEntry; 	// ARP table, Linked list.  
  private NetworkInterface ni;
  private HWAddr hwaddr;
  
  ARP(NetworkInterface ni,HWAddr hwaddr)
  {
    protocolNumber=0x806;
    firstEntry=null;
    next=null;
    this.ni=ni;
    this.hwaddr=hwaddr;
  }

  ARPTableEntry find(IPAddr ipaddr) 		// Search the Table
  {
    ARPTableEntry currentEntry=firstEntry;
    while ((currentEntry != null))
    {
      if (currentEntry.getIPAddr().equals(ipaddr)) 
        {return currentEntry;}
      currentEntry=currentEntry.getNextEntry();
    }  
    return null;
  }

  public HWAddr getHWAddr(IPAddr ipaddr)
  {
    ARPTableEntry ent = find(ipaddr);
    if (ent!=null)
    { return ent.getHWAddr(); }
    else {
      System.out.println(ipaddr.toString()+" not found in ARP cache");
      return null;
    }
  }

  void add(ARPTableEntry newEntry)
  {
    /* New Entries are added to the front of the list 
       as we assume they are going to be the subject
       of immidiate communication. */
    newEntry.setNextEntry(firstEntry);
    firstEntry = newEntry;
  }

  /* 
   * Tries to conform to the procedure outlined in RFC 826
   */
  public void Handle(Packet p)
  {
    ARPPacket ap=new ARPPacket(p.data);
    if (ap.hwa_fmt!=1) return;		// This is Ethernet
    if (ap.prota_fmt!=0x800) return;	// We only speak IP
    boolean merge = false;
    ARPTableEntry currentEntry = find(ap.ip_src);
    if (currentEntry!=null)
    {
      currentEntry.setHWAddr(ap.hw_src);
      currentEntry.touch();
      merge=true;
    }
    if (!ap.ip_dest.equals(ni.ipaddr)) return;  // Not for us!
    if (!merge)
    {
      add(new ARPTableEntry(ARPTableEntry.ARP_STATE_RESOLVED,ap.hw_src,ap.ip_src));
    }
    if (ap.operation==ARPPacket.ARP_REQ)	// Send reply.
    {
      ni.writePacket(new ARPPacket(hwaddr,ni.ipaddr,ap.hw_src,ap.ip_src,ARPPacket.ARP_REP),
			hwaddr,ap.hw_src,protocolNumber);	
    }
  }
};
