#include <config.h>
#include <jni.h>
#include <stdlib.h>
#include <stdio.h>

#include "interp.h"
#include "interp_methods.h"
#include "newobject.h"

#include "VMSecurityManager.h"


jobjectArray java_lang_VMSecurityManager_getClassContext(JNIEnv *env, jclass obj)
{
  tStackFrame* f;
  int num_frames = 0;
  int i;
  jarray cls_array;
  jclass cls_cls = (*env)->FindClass(env, "java/lang/Class");
  
  f = JNI_getJNIData(sys_current_thread())->pstTopFrame; //top_frame;
  while (f != NULL) 
      {
	  num_frames ++;
	  f = f->pstPrevFrame;
      }

  eprintf("In getClassContext() GOT HERE %i\n", num_frames);

  cls_array = (*env)->NewObjectArray(env, num_frames, cls_cls, NULL);
  (*env)->NewLocalRef(env, (jobject) cls_array);
  i = 0;
  f = JNI_getJNIData(sys_current_thread())->pstTopFrame; 
  while (f != NULL) 
      {
	  (*env)->SetObjectArrayElement(env, cls_array, i++,  CLASS_MakeClassObject(env, f->pstCurrMethod->pstClass)); 
	  f = f->pstPrevFrame; //parent;
      }

  return cls_array;
}             

/** Get the current ClassLoader--the one nearest to the
 ** top of the stack.
 ** @return the current ClassLoader.
 **/

//static native ClassLoader currentClassLoader();
jobject java_lang_VMSecurityManager_currentClassLoader(JNIEnv *env, jclass obj)
{
 tStackFrame* f;
  f = JNI_getJNIData(sys_current_thread())->pstTopFrame; //top_frame;
  while (f != NULL) 
 {
  if(f->pstCurrClass->classLoader)
    return f->pstCurrClass->classLoader;
  f = f->pstPrevFrame;
 }
  return NULL;
}
