#include <config.h>
#include <stdlib.h>
#include <stdio.h>

#include <assert.h>
#include "jni.h"

#include "../java.lang/java_lang_Class.h"
#include "../java.lang/Class.h"
#include "../java.lang/Class_Reflection.h"

#include "java_lang_reflect_Field.h"

#include "classfile_methods.h"
#include "interp_methods.h"


jint Java_java_lang_reflect_Field_getModifiers(JNIEnv* env, jobject obj)
{
    return 0;
}


jclass Java_java_lang_reflect_Field_getType(JNIEnv* env, jobject obj)
{
        jclass fieldClazz;
	jfieldID decClassField;
	jclass retval;

       fieldClazz = CLASS_GetClass(env,obj);


       decClassField = (*env)->GetFieldID(env, fieldClazz, "declaringClass", NULL);


       retval = (*env)->GetObjectField(env, obj, decClassField);

       return retval;
}


tField* FIELD_getInternalFieldStruct(JNIEnv* env, jobject fieldObject)
{
tClassLoaderTuple* pstType;
int slot;

jfieldID decClassField;       
jfieldID slotField;       
jclass fieldClazz;
jclass decClass;

fieldClazz = CLASS_GetClass(env, fieldObject);
decClassField = (*env)->GetFieldID(env, fieldClazz, "declaringClass", "Ljava/lang/Class;");
decClass = (*env)->GetObjectField(env, fieldObject, decClassField);
pstType = CLASS_GetClassStruct( env, decClass );
assert(pstType);

slotField = (*env)->GetFieldID(env, fieldClazz, "slot", "I");

assert(slotField);

slot =  (*env)->GetIntField(env, fieldObject, slotField);

return pstType->pstClass->pstInstOffsets + slot;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    get
 * Signature: (Ljava/lang/Object;)Ljava/lang/Object;
 */
JNIEXPORT jobject JNICALL Java_java_lang_reflect_Field_get
  (JNIEnv* env, jobject fieldObject, jobject obj) {
    jclass theClass;  
    jboolean isPrimitive;
    tField* pstField; 
    
    pstField = FIELD_getInternalFieldStruct(env, fieldObject);
    

    theClass = CLASS_MakeClassObject(env, pstField->pstClass);
    isPrimitive = Java_java_lang_Class_isPrimitive(  env,  theClass );
    if(isPrimitive)
      {
	//the declaringClass should give us the type?
	    eprintf("type is %s\n", CLASS_GetClassStruct(env, theClass)->uidName);
	assert( 1==2);
      }
    else
      {
	assert( ODEREF(obj)->pstType == pstField->pstClass);
	if(pstField->u16AccessFlags & ACC_STATIC)
	  {
	    return (jobject) pstField->pstClass->pi32StatVars[ pstField->u16Offset ];
	  }
	else
	  {
	    return (jobject) ODEREF(obj)->pi32Vars[ pstField->u16Offset ];
	  }
      }
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    getBoolean
 * Signature: (Ljava/lang/Object;)Z
 */
JNIEXPORT jboolean JNICALL Java_java_lang_reflect_Field_getBoolean
(JNIEnv* env, jobject fieldObject, jobject obj)
{
  assert(1 == 2);
  return JNI_FALSE;
}


/*
 * Class:     java_lang_reflect_Field
 * Method:    getByte
 * Signature: (Ljava/lang/Object;)B
 */
JNIEXPORT jbyte JNICALL Java_java_lang_reflect_Field_getByte
  (JNIEnv* env, jobject fieldObject, jobject obj)
{
  assert(1 == 2);
  return 0;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    getShort
 * Signature: (Ljava/lang/Object;)S
 */
JNIEXPORT jshort JNICALL Java_java_lang_reflect_Field_getShort
  (JNIEnv* env, jobject fieldObject, jobject obj)
{
  assert(1 == 2);
  return 0;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    getChar
 * Signature: (Ljava/lang/Object;)C
 */
JNIEXPORT jchar JNICALL Java_java_lang_reflect_Field_getChar
  (JNIEnv* env, jobject fieldObject, jobject obj)
{
 assert(1 == 2);
  return 0;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    getInt
 * Signature: (Ljava/lang/Object;)I
 */
JNIEXPORT jint JNICALL Java_java_lang_reflect_Field_getInt
  (JNIEnv* env, jobject fieldObject, jobject obj)
{
 assert(1 == 2);
  return 0;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    getLong
 * Signature: (Ljava/lang/Object;)J
 */
JNIEXPORT jlong JNICALL Java_java_lang_reflect_Field_getLong
  (JNIEnv* env, jobject fieldObject, jobject obj)
{
  jlong ret;
 assert(1 == 2);
  return ret;
}
 

/*
 * Class:     java_lang_reflect_Field
 * Method:    getFloat
 * Signature: (Ljava/lang/Object;)F
 */
JNIEXPORT jfloat JNICALL Java_java_lang_reflect_Field_getFloat
  (JNIEnv* env, jobject fieldObject, jobject obj)
{
 assert(1 == 2);
 return 0.0;
}
 

/*
 * Class:     java_lang_reflect_Field
 * Method:    getDouble
 * Signature: (Ljava/lang/Object;)D
 */
JNIEXPORT jdouble JNICALL Java_java_lang_reflect_Field_getDouble
  (JNIEnv* env, jobject fieldObject, jobject obj)
{
 assert(1 == 2);
 return 0.0;
}
 

/*
 * Class:     java_lang_reflect_Field
 * Method:    set
 * Signature: (Ljava/lang/Object;Ljava/lang/Object;)V
 */
JNIEXPORT void JNICALL Java_java_lang_reflect_Field_set
  (JNIEnv* env, jobject fieldObject, jobject obj, jobject value)
{
  assert(1 == 2);
  return;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    setBoolean
 * Signature: (Ljava/lang/Object;Z)V
 */
JNIEXPORT void JNICALL Java_java_lang_reflect_Field_setBoolean
  (JNIEnv* env, jobject fieldObject, jobject obj, jboolean value)
{
  assert(1 == 2);
  return;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    setByte
 * Signature: (Ljava/lang/Object;B)V
 */
JNIEXPORT void JNICALL Java_java_lang_reflect_Field_setByte
  (JNIEnv* env, jobject fieldObject, jobject obj, jbyte value)
{
  assert(1 == 2);
  return;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    setShort
 * Signature: (Ljava/lang/Object;S)V
 */
JNIEXPORT void JNICALL Java_java_lang_reflect_Field_setShort
  (JNIEnv *env, jobject fieldObject, jobject obj, jshort value)
{
  assert(1 == 2);
  return;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    setChar
 * Signature: (Ljava/lang/Object;C)V
 */
JNIEXPORT void JNICALL Java_java_lang_reflect_Field_setChar
  (JNIEnv *env, jobject fieldObject, jobject obj, jchar value)
{
  assert(1 == 2);
  return;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    setInt
 * Signature: (Ljava/lang/Object;I)V
 */
JNIEXPORT void JNICALL Java_java_lang_reflect_Field_setInt
  (JNIEnv *env, jobject fieldObject, jobject obj, jint value)
{
  assert(1 == 2);
  return;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    setLong
 * Signature: (Ljava/lang/Object;J)V
 */
JNIEXPORT void JNICALL Java_java_lang_reflect_Field_setLong
  (JNIEnv *env, jobject fieldObject, jobject obj, jlong value)
{
  assert(1 == 2);
  return;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    setFloat
 * Signature: (Ljava/lang/Object;F)V
 */
JNIEXPORT void JNICALL Java_java_lang_reflect_Field_setFloat
  (JNIEnv *env, jobject fieldObject, jobject obj, jfloat value)
{
  assert(1 == 2);
  return;
}

/*
 * Class:     java_lang_reflect_Field
 * Method:    setDouble
 * Signature: (Ljava/lang/Object;D)V
 */
JNIEXPORT void JNICALL Java_java_lang_reflect_Field_setDouble
  (JNIEnv *env, jobject fieldObject, jobject obj, jdouble value)
{
  assert(1 == 2);
  return;
}



