#include <config.h>
#include "jni.h"
#include "interp.h"
#include <stdio.h>
#include "classex.h"

#include "classfile_methods.h"
#include "interp_methods.h"
#include "newobject.h"
#ifdef DEBUG
#include <assert.h>
#endif

extern tClassLoaderTuple* pstClassType; // this can be globally used to get the type for class

/*

  StackTrace has members:

	StackFrame[] frames;
	int len;

  StackFrame has the following members:

	StackFrame caller;
	Object obj;
	Method method;
	int lineNum;
	String filename;

 */

extern int INTERP_DebugOn;
extern tOBREF OOMExceptionObject;

jobject gnu_vm_stack_StackTrace_copyCurrentStackTrace(

  JNIEnv* env,
  jclass clazz
)

{
  tJNIData* pstJNIData = JNI_getJNIData( sys_current_thread());
  tStackFrame* f;
  tOBREF prevStackFrame = NULL;

  int num_frames = 0;
  int i;
  jarray cls_array = NULL;
  jclass StackFrame_cls = (*env)->FindClass(env, "gnu/vm/stack/StackFrame");

  // First count the number of frames

  f = pstJNIData->pstTopFrame; //top_frame;
	while (f != NULL) 
		{
		          num_frames ++;
			  f = f->pstPrevFrame;
		}

   //Create an array of StackFrame's
    cls_array = (*env)->NewObjectArray(env, num_frames, StackFrame_cls, NULL);
if(cls_array == NULL)
{
(*env)->Throw(env, OOMExceptionObject);
 return NULL;
}

eprintf("Created new array with %i items\n", num_frames);
   i = 0;
   f = pstJNIData->pstTopFrame; //top_frame;
   while (f != NULL) 
	{
	    jfieldID callerField;
	    jfieldID objField;
	    jfieldID methodField;
	    jfieldID lineNumField;
	    jfieldID filenameField;

	    //Create each StackFrame
	    tClassLoaderTuple* sfclazz = CLASSFILE_FindOrLoad(env, "gnu/vm/stack/StackFrame", pstClassType); //XXX System calss
	    tOBREF stackObject;

if(sfclazz == NULL) //should actually be class not found
{
(*env)->Throw(env, OOMExceptionObject);
 return NULL;
}
stackObject = INTERP_NewObject(env,sfclazz) ;

if(stackObject == NULL) 
{
(*env)->Throw(env, OOMExceptionObject);
 return NULL;
}
	
	    callerField = (*env)->GetFieldID(env, StackFrame_cls, "caller", "Lgnu/vm/stack/StackFrame;");
	    objField = (*env)->GetFieldID(env, StackFrame_cls, "obj", "Ljava/lang/Object;");
	    methodField = (*env)->GetFieldID(env, StackFrame_cls, "method", "Ljava/lang/reflect/Method;");
	    lineNumField = (*env)->GetFieldID(env, StackFrame_cls, "lineNum", "I");
	    filenameField = (*env)->GetFieldID(env, StackFrame_cls, "filename", "Ljava/lang/String;");

	    (*env)->SetObjectField(env, stackObject, callerField, prevStackFrame);
	    prevStackFrame = stackObject;

	    (*env)->SetObjectField(env, stackObject, objField, f->pstCurrObject);


	    /* Now construct a Method object */

	    /*
	Class declaringClass;
	String name;
	int slot;

	    */
/*
	    {
		tClass* methodClazz = CLASSFILE_FindOrLoad(env, "java/lang/reflect/Method");
		tOBREF newMethodObject = INTERP_NewObject(env,methodClazz);
		jclass methodClass = (*env)->FindClass(env, "java/lang/reflect/Method");
		jfieldID decField;
		jfieldID nameField;
		jfieldID slotField;
		jclass methodClassObject;
		
if(newMethodObject == NULL)
{
(*env)->Throw(env, OOMExceptionObject);
 return NULL;
}
	    decField = (*env)->GetFieldID(env, methodClass, "declaringClass", "Ljava/lang/Class;");
	    nameField = (*env)->GetFieldID(env, methodClass, "name", "Ljava/lang/String;");
	    slotField = (*env)->GetFieldID(env, methodClass, "slot", "I");

	    methodClassObject = (*env)->FindClass(env, f->pstCurrMethod->pstClass->uidName);
#ifdef DEBUG
	    assert(methodClassObject);
#endif
	    (*env)->SetObjectField(env, newMethodObject, decField, methodClassObject);
	    (*env)->SetIntField(env, newMethodObject, slotField, 0); //XXX this isn't right
	    (*env)->SetObjectField(env, newMethodObject, nameField, INTERP_NewStringFromAsciz(f->pstCurrMethod->uidName));
*/

       	    (*env)->SetObjectField(env, stackObject, methodField, NULL); //newMethodObject);

//	    }
       	    (*env)->SetIntField(env, stackObject, lineNumField, 0); 
       	    (*env)->SetObjectField(env, stackObject, filenameField, INTERP_NewStringFromAsciz(env, f->pstCurrMethod->pstClass->uidName)); 


	    (*env)->SetObjectArrayElement(env, cls_array, i++,  stackObject);


	    f = f->pstPrevFrame; //parent;
	}

    
   //Now create the StackTrace object
   {

	    
       jclass StackTrace_cls = (*env)->FindClass(env, "gnu/vm/stack/StackTrace");
       tClassLoaderTuple* stclazz = CLASSFILE_FindOrLoad(env, "gnu/vm/stack/StackTrace", pstClassType); //XXX System type
       tOBREF traceObject = INTERP_NewObject(env, stclazz);
       jfieldID framesField;
       jfieldID lenField;

#ifdef DEBUG
       assert(traceObject);
#endif
       framesField = (*env)->GetFieldID(env, StackTrace_cls, "frames", "[Lgnu/vm/stack/StackFrame;");
       lenField = (*env)->GetFieldID(env, StackTrace_cls, "len", "I");

#ifdef DEBUG
       assert(framesField);
       assert(lenField);
#endif
       (*env)->SetIntField(env, traceObject, lenField, num_frames); 
       (*env)->SetObjectField(env, traceObject, framesField, (jobject) cls_array); 

              return traceObject;
   }
    

}

