/*************************************************************************
 * Float.c - java.lang.Float native functions
 *
 * Copyright (c) 1998 Free Software Foundation, Inc.
 * Written by Brian Jones (cbj@gnu.org)
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA
 *************************************************************************/

#include <config.h>
#include <stdlib.h>  /* for strtod() */
#include <math.h>  /* for HUGE_VAL */

#include <stdio.h>

#include "javalang.h"
#include "java_lang_Float.h"

#ifdef OLD
/*
 * Class:     java_lang_Float
 * Method:    floatToIntBits
 * Signature: (F)I
 */
JNIEXPORT jint JNICALL Java_java_lang_Float_floatToIntBits
  (JNIEnv * env, jclass thisClass, jfloat floatValue)
{
    jvalue val;
    val.f = floatValue;
    return val.i;
}

/*
 * Class:     java_lang_Float
 * Method:    intBitsToFloat
 * Signature: (I)F
 */
JNIEXPORT jfloat JNICALL Java_java_lang_Float_intBitsToFloat
  (JNIEnv * env, jclass thisClass, jint intValue)
{
    jvalue val;
    val.i = intValue;
    return val.f;
}


/*
 * Class:    java_lang_Float
 * Method:   toString(float f)
 * Signature: (F)Ljava/lang/String
 */
JNIEXPORT jstring JNICALL Java_java_lang_Float_toString
  (JNIEnv * env, jclass thisClass, jfloat f)
{
  char buf[1024];
  jstring retval;

  jint bits = Java_java_lang_Float_floatToIntBits(env, thisClass, f);
  if( bits == 0x80000000)
    {
      sprintf(buf, "-0.0");
    }
  else if(bits == 0x0)
    {
      sprintf(buf, "0.0");
    }
  else if(bits == 0xff800000)
   {
	sprintf(buf, "-Infinity");
   }
  else if(bits == 0x7f800000)
    {
      	sprintf(buf, "Infinity");
    }
  else
    {
      /*      if(f < pow(10,7))
	{
	  sprintf(buf, "G", f);
	  if(strchr(buf, '.') == NULL)
	    {
	      strcat(buf, ".0");
	    }
	}
      else*/
	sprintf(buf, "%G", f);
    }
  retval = (*env)->NewStringUTF(env, buf);
  return retval;
}
#endif


