package kissme_test;


import java.lang.reflect.*;

public class TestSuite {

  public static String[] simpleTests = {
    "kissme_test.BigIntegerTest",
    "kissme_test.Child",
    "kissme_test.CloneTest",
    "kissme_test.DataStreamTest",
    "kissme_test.DoubleTest1",
    "kissme_test.ExceptionTest",
    "kissme_test.ExceptionTest2",
    "kissme_test.ExceptionTest3",
    "kissme_test.FieldTest",
    "kissme_test.FieldTest2",
    "kissme_test.FileURLConnection2",
    "kissme_test.FloatTest2",
    "kissme_test.InheritanceTest",
    "kissme_test.InputTest",
    "kissme_test.kissme_test.InstanceChild",
    "kissme_test.InstanceTest",
    "kissme_test.LocalHostTest",
    "kissme_test.ManyThreads",
    //    "kissme_test.MapTester",
    //    "kissme_test.MyFunkyInterface",
    //    "kissme_test.MyRandom",
    //    "kissme_test.NativeTest",
    //    "kissme_test.Optimiser2",
    //    "kissme_test.Optimiser3",
    //    "kissme_test.Optimiser4",
    //    "kissme_test.Optimiser5",
    //    "kissme_test.Optimiser6",
    //    "kissme_test.OptimiserControl",
    "kissme_test.ReadLineTest", //halfway
    "kissme_test.ReflectionTest3",
    "kissme_test.ReflectionTest4",
    "kissme_test.ReflectionTest5",
    "kissme_test.ResourceTest",
    "kissme_test.SecondChild",
    "kissme_test.SelfReference",
    //    "kissme_test.ShiftTest",
    "kissme_test.StackTest",
    "kissme_test.SvetaTest", 
    "kissme_test.Tester", //hw + 10
    "kissme_test.ThreadTest3",
    //    "kissme_test.WaitNotify",
    "kissme_test.ZipTest",
    //    "kissme_test.allocClass",
    "kissme_test.bipush",
    "kissme_test.helloCharacter",
    "kissme_test.invoke_virtual_quick",
    "kissme_test.sipush",
    //    "kissme_test.stressmem2",//hw + 20
    //    "kissme_test.stressmem3",
    //    "kissme_test.stressmem4",
    //    "kissme_test.stressmem5",
    //    "kissme_test.stressmem6",
    //    "kissme_test.stressmem7",
    //    "kissme_test.stressmem_MT",
  };

  public static void main(String[] argv)
  {
    int numFailed = 0;

    for(int i = 0; i < simpleTests.length;i++)
      {
	try { 
	  System.err.println("Running test \"" + simpleTests[i] + "\"");
	  doTest(simpleTests[i]);
	} catch(Exception e)
	  {
	    numFailed++;
	    e.printStackTrace();  
	  }
      }
    System.err.println(numFailed + " failed out of " + simpleTests.length);
  }

  public static void doTest(String test) throws Exception
    {
      Class[] types = new Class[1];
      types[0] = String[].class;

      Class c = Class.forName(test);
      Method m = c.getMethod("main", types);

      Object[] args = new Object[1];
      args[0] = new String[0];
      m.invoke(null, args);
    }
}
