package kissme_test;

/* Tests whether the Svetlana optimiser (cavalry) can optimise array-related operations */

public class SArrayTest
{

    public void check( boolean arg, String method ) throws ControlException
    {
	if(!arg)
	    throw new ControlException(method + " failed ");
    }

    public byte int2byte(int a)
    {
	return (byte) a;
    }

    //Loading two bytes from an array, adding them

    public byte basic1(byte[] array)
    {
	return (byte) (array[0] + array[1]);
    }

    //Storing two bytes in an array

    public int basic2(byte[] array)
    {
	array[0] = -27;
	array[1] =  12;
	return 0;
    }

    public static void main(String[] argv) throws ControlException
    {
	SArrayTest o1 = new SArrayTest();

	byte[] basic1A = new byte[2];
	basic1A[0] = -31;
	basic1A[1] = -24;

	    for(int i = 0; i < 5 ;i++)
		o1.check( o1.int2byte(-27) == -27," int2byte " + o1.int2byte(-27));
	    for(int i = 0; i < 5 ;i++)
		o1.check( o1.int2byte(37) == 37," int2byte " + o1.int2byte(37));

	    for(int i = 0; i < 5 ;i++)
		o1.check( o1.basic1(basic1A) == -55," basic1 " + o1.basic1(basic1A));

    	basic1A[0] = 0;
	basic1A[1] = 0;

	    for(int i = 0; i < 5 ;i++)
		o1.check( (o1.basic2(basic1A) == 0) && ( basic1A[0] + basic1A[1] == -15)," basic2 " + o1.basic2(basic1A));


    }

    public SArrayTest()
    {
    }

}
