package java.awt;

import java.awt.event.InputEvent;
import teaseme.console.Console;
import org.log4j.Category;

/**
  * This class implements a single line text entry field widget
  *
  */

public class TextField extends TextComponent implements java.io.Serializable
{ 

private static Category DEBUG = Category.getInstance(TextField.class.getName());

private boolean wraps = false;

  /* Redraws this widget on the curses screen */

public void paint()
  {
    DEBUG.info("in TextField.paint start");

    //we should first paint the spaces, so that the cursor ends up in the correct position

    int fieldWidth = CoordinateManager.convertFromPixelPoint(new Point( getBounds().width, getBounds().height)).x;

    Console c = Toolkit.getConsole();

    if(c == null)
      DEBUG.error("console is null");
    if(getBounds() == null)
      DEBUG.error("getBounds() is null");
    if(getText() == null)
      DEBUG.error("getText() is null");

    c.setCurrentCursorPosition( CoordinateManager.convertFromPixelPoint(new Point(getBounds().x, getBounds().y)).shift(getText().length(), 0));

    for(int i = getText().length(); i < fieldWidth;i++)
	c.writeChar(' ');

    Point cursorPos = CoordinateManager.convertFromPixelPoint(new Point(getBounds().x, getBounds().y));

    c.setCurrentCursorPosition( cursorPos );

    for(int i = 0; i < getText().length();i++)
      c.writeChar(getText().charAt(i));

    DEBUG.info("in TextField.paint, width " + fieldWidth + ", chars " + getText().length() + ", cursor pos is " + cursorPos);
    c.refresh();
  }

private Point cursorPosition;

public boolean handleInputEvent(InputEvent ie)
  {
    Console c = Toolkit.getConsole();
    Point ourLocation = CoordinateManager.convertFromPixelPoint( getBounds().getLocation());
    Rectangle ourDimension = CoordinateManager.convertFromPixelDimension( getBounds());
    int txtLength;

    if(ie.getKeystroke() == 0xd)
      {
	//send ACTION_EVENT to all the listeners
      }
    else if((ie.getKeystroke() == 0x41) || (ie.getKeystroke() == 0x5b) || (ie.getKeystroke() == 0x1b))
      {
	//up arrow
      }
    else if(ie.getKeystroke() == 0x42)
      {

      }
    else if(ie.getKeystroke() == 0x7f)
      {
	//backspace
	txtLength = getText().length();

	if(txtLength != 0)
	  {
	    String firstString = getText().substring(0, cursorPosition.x);
	    String secondString = "";
	    if(cursorPosition.x > txtLength - 1)
	      secondString = getText().substring(cursorPosition.x);

	    this.text = ( firstString.substring(0, firstString.length() - 1) + secondString);

	    cursorPosition = new Point( cursorPosition.x - 1, cursorPosition.y);

	    c.setCurrentCursorPosition( new Point( ourLocation.x + cursorPosition.x, ourLocation.y + cursorPosition.y));
	  }

      }
    else
      {
	txtLength = getText().length();

	if(wraps == false)
	  {
	    if(txtLength  > (ourDimension.width - 1))
	      {
		
	      }
	    else
	      {
		try {
		String firstString = "";
		if(cursorPosition.x > 0)
		  firstString = getText().substring(0, cursorPosition.x);
		String secondString = "";
		if(cursorPosition.x > txtLength - 1)
		  secondString = getText().substring(cursorPosition.x);
		
		this.text = ( firstString + (char) ie.getKeystroke() + secondString);
		
		cursorPosition = new Point( cursorPosition.x + 1, cursorPosition.y);

		if(ourLocation == null)
		  DEBUG.error("ourLocation is null in TextField");
		c.setCurrentCursorPosition( new Point( ourLocation.x + cursorPosition.x, ourLocation.y + cursorPosition.y));

		} catch(StringIndexOutOfBoundsException sie)
		  {
		    DEBUG.error("could not add letter", sie);
		  }
	      }
	  }
      }



    paint();

    return true;
  }

/*
 * Instance Variables
 */

/**
  * @serial The number of columns in the text entry field.
  */
private int columns;

/**
  * @serial The character that is echoed when doing protected input
  */
private char echoChar;

/*
 * Constructors
 */

/*
 * Initializes a new instance of <code>TextField</code> that is empty
 * and has one column.
 */
public
TextField()
{
  this("", 1);
}

/*************************************************************************/

/**
  * Initializes a new instance of <code>TextField</code> containing
  * the specified text.  The number of columns will be equal to the
  * length of the text string.
  *
  * @param text The text to display in the field.
  */
public
TextField(String text)
{
  this(text, text.length());
}

/*************************************************************************/

/**
  * Initializes a new instance of <code>TextField</code> that is empty
  * and has the specified number of columns.
  *
  * @param columns The number of columns in the text field.
  */
public
TextField(int columns)
{
  this("", columns);
}

/*************************************************************************/

/**
  * Initializes a new instance of <code>TextField</code> with the
  * specified text and number of columns.
  *
  * @param text The text to display in the field.
  * @param columns The number of columns in the field.
  */
public
TextField(String text, int columns)
{
  super(text);
  this.columns = columns;

  cursorPosition = new Point(0,0);
}

/*************************************************************************/

/*
 * Instance Methods
 */

/**
  * Returns the number of columns in the field.
  *
  * @return The number of columns in the field.
  */
public int
getColumns()
{
  return(columns);
}


public void setText(String s)
{
  super.setText(s);
  cursorPosition = new Point( s.length(), cursorPosition.y);
}
/*************************************************************************/

/**
  * Sets the number of columns in this field to the specified value.
  *
  * @param columns The new number of columns in the field.
  *
  * @exception IllegalArgumentException If columns is less than zero.
  */
public synchronized void
setColumns(int columns)
{
  if (columns < 0)
    throw new IllegalArgumentException("Value is less than zero: " +
                                       columns);

  this.columns = columns;
  // FIXME: How to we communicate this to our peer?
}

/*************************************************************************/

/**
  * Returns the character that is echoed to the screen when a text 
  * field is protected (such as when a password is being entered).
  *
  * @return The echo character for this text field.
  */
public char
getEchoChar()
{
  return(echoChar);
}

/*************************************************************************/

/**
  * Sets the character that is echoed when protected input such as
  * a password is displayed.
  *
  * @param echoChar The new echo character.
  */
public void
setEchoChar(char echoChar)
{
  this.echoChar = echoChar;
}

/*************************************************************************/

/**
  * Sets the character that is echoed when protected input such as
  * a password is displayed.
  *
  * @param echoChar The new echo character.
  *
  * @deprecated This method is deprecated in favor of 
  * <code>setEchoChar()</code>
  */
public void
setEchoCharacter(char echoChar)
{
  setEchoChar(echoChar);
}

/*************************************************************************/

/**
  * Tests whether or not this text field has an echo character set
  * so that characters the user type are not echoed to the screen.
  *
  * @return <code>true</code> if an echo character is set,
  * <code>false</code> otherwise.
  */
public boolean
echoCharIsSet()
{
  if (echoChar == '\u0000')
    return(false);
  else
    return(true);
}

/*************************************************************************/

/**
  * Returns the minimum size for this text field.
  *
  * @return The minimum size for this text field.
  */
public Dimension
getMinimumSize()
{
  return(getMinimumSize(getColumns()));
}

/*************************************************************************/

/**
  * Returns the minimum size of a text field with the specified number
  * of columns.
  *
  * @param columns The number of columns to get the minimum size for.
  */
public Dimension
getMinimumSize(int columns)
{
  /*  TextFieldPeer tfp = (TextFieldPeer)getPeer();
  if (tfp == null)
    return(null); // FIXME: What do we do if there is no peer?

  return(tfp.getMinimumSize(columns));
  */
  return null;
}

/*************************************************************************/

/**
  * Returns the minimum size for this text field.
  *
  * @return The minimum size for this text field.
  *
  * @deprecated This method is depcreated in favor of
  * <code>getMinimumSize()</code>.
  */
public Dimension
minimumSize()
{
  return(getMinimumSize(getColumns()));
}

/*************************************************************************/

/**
  * Returns the minimum size of a text field with the specified number
  * of columns.
  *
  * @param columns The number of columns to get the minimum size for.
  *
  * @deprecated This method is deprecated in favor of 
  * <code>getMinimumSize(int)</code>.
  */
public Dimension
minimumSize(int columns)
{
  return(getMinimumSize(columns));
}

/*************************************************************************/

/**
  * Returns the preferred size for this text field.
  *
  * @return The preferred size for this text field.
  */
public Dimension
getPreferredSize()
{
  return(getPreferredSize(getColumns()));
}

/*************************************************************************/

/**
  * Returns the preferred size of a text field with the specified number
  * of columns.
  *
  * @param columns The number of columns to get the preferred size for.
  */
public Dimension
getPreferredSize(int columns)
{
  /*
  TextFieldPeer tfp = (TextFieldPeer)getPeer();
  if (tfp == null)
    return(null); // FIXME: What do we do if there is no peer?

  return(tfp.getPreferredSize(columns));
  */
  return null;
}

/*************************************************************************/

/**
  * Returns the preferred size for this text field.
  *
  * @return The preferred size for this text field.
  *
  * @deprecated This method is deprecated in favor of 
  * <code>getPreferredSize()</code>.
  */
public Dimension
preferredSize()
{
  return(getPreferredSize(getColumns()));
}

/*************************************************************************/

/**
  * Returns the preferred size of a text field with the specified number
  * of columns.
  *
  * @param columns The number of columns to get the preferred size for.
  *
  * @deprecated This method is deprecated in favor of 
  * <code>getPreferredSize(int)</code>.
  */
public Dimension
preferredSize(int columns)
{
  return(getPreferredSize(columns));
}



}
