#ifndef __FRONTEND_H__
#define __FRONTEND_H__

// I tend to think this should be split into a front end and a
// packet tracker

#include <stdio.h>
#include <time.h>
#include <list.h>
#include <map.h>
#include <string>

#include "config.h"
#include "packet.h"
#include "packetracker.h"
#include "gpsd.h"

class Frontend {
public:
    // Associate a tracker
    void AddTracker(Packetracker *in_tracker) { tracker = in_tracker; };
    void AddGPS(GPSD *in_gps) { gps = in_gps; };

    // Init the screen
    virtual int InitDisplay(int in_decay) = 0;

    // Draw the screen
    virtual int DrawDisplay() = 0;

    // End
    virtual int EndDisplay() = 0;

    virtual int WriteStatus(string status) = 0;

    // Get the error
    char *FetchError() { return errstr; };

protected:
    int decay;
    char errstr[1024];

    time_t start_time;

    Packetracker *tracker;
    GPSD *gps;

};

#endif

