#include <gtk/gtk.h>
#include <glib-object.h>

#include "../kptraininglog.h"
#include "../kipina-i18n.h"

#include "kpviewmodel.h"

static void         kp_view_model_base_init         (GObjectClass *klass);

enum {
  DATE_SET,
  VIEW_SET,
  LAST_SIGNAL
};

static guint kp_view_model_signals[LAST_SIGNAL] = { 0 };

GType
kp_view_model_get_type ()
{
  static GType kp_view_model_type = 0;

  if (!kp_view_model_type) {
    static const GTypeInfo kp_view_model_info = {
      sizeof (KPViewModelIface),
      (GBaseInitFunc) kp_view_model_base_init,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL
    };
    kp_view_model_type = g_type_register_static (G_TYPE_INTERFACE,
                                                "KPViewModel",
                                                &kp_view_model_info,
                                                 0);
    g_type_interface_add_prerequisite (kp_view_model_type, GTK_TYPE_WIDGET);
  }
  return kp_view_model_type;
}

static void
kp_view_model_base_init (GObjectClass * klass)
{
  static gboolean initialized = FALSE;

  if (!initialized) {
    kp_view_model_signals[DATE_SET] = 
      g_signal_new ("date-set",
                    KP_TYPE_VIEW_MODEL,
                    G_SIGNAL_RUN_LAST,
                    G_STRUCT_OFFSET (KPViewModelIface, date_set),
                    NULL, NULL,
                    g_cclosure_marshal_VOID__POINTER,
                    G_TYPE_NONE,
                    1,
                    G_TYPE_POINTER);
    kp_view_model_signals[VIEW_SET] = 
      g_signal_new ("view-set",
                    KP_TYPE_VIEW_MODEL,
                    G_SIGNAL_RUN_LAST,
                    G_STRUCT_OFFSET (KPViewModelIface, view_set),
                    NULL,
                    NULL,
                    g_cclosure_marshal_VOID__UINT,
                    G_TYPE_NONE,
                    1,
                    G_TYPE_UINT);
    
    initialized = TRUE;
  }
}


void
kp_view_model_set_dmy (KPViewModel *model, guint d, guint m, guint y)
{
  KPDate *date;
  KP_VIEW_MODEL_GET_CLASS (model)->set_dmy (model, d, m, y);

  date = kp_date_new_dmy (d, m, y);
  g_signal_emit (model, kp_view_model_signals[DATE_SET], 0, date);
  kp_date_free (date);
}

void
kp_view_model_get_dmy (KPViewModel *model, guint *d, guint *m, guint *y)
{
  KP_VIEW_MODEL_GET_CLASS (model)->get_dmy (model, d, m, y);
}
  
void
kp_view_model_set_view_type (KPViewModel *model, KPViewModelType type)
{
  KP_VIEW_MODEL_GET_CLASS (model)->set_view_type (model, type);

  g_signal_emit (model, kp_view_model_signals[VIEW_SET], 0, type);
}


KPViewModelType
kp_view_model_get_view_type (KPViewModel *model)
{
  return KP_VIEW_MODEL_GET_CLASS (model)->get_view_type (model);
}

void
kp_view_model_set_log (KPViewModel *model, KPTrainingLog *log)
{
  KP_VIEW_MODEL_GET_CLASS (model)->set_log (model, log);
}

void
kp_view_model_unset_log (KPViewModel *model)
{
  KP_VIEW_MODEL_GET_CLASS (model)->unset_log (model);
}


gchar *
kp_view_model_get_date_format (KPViewModel *model)
{
  KPViewModelType type;
  
  type = KP_VIEW_MODEL_GET_CLASS (model)->get_view_type (model);
  
  switch (type)
  {
    case KP_VIEW_MODEL_TYPE_WEEK:
      return g_strdup (_("Week %V/%Y"));
      
    case KP_VIEW_MODEL_TYPE_MONTH:
      return g_strdup ("%B %Y");
      
    case KP_VIEW_MODEL_TYPE_YEAR:
      return g_strdup ("%Y");
    
    case KP_VIEW_MODEL_TYPE_ALL_TIME:
      return g_strdup (_("All time"));
    
    case KP_VIEW_MODEL_TYPE_DAY:
      return g_strdup ("%x");
    
    default:
      g_assert_not_reached ();
  }
  /* Prevent a compiler warning */
  return NULL;
}
