// $Id:

/*
 * Copyright (C) 2001 Dan Dennedy <dan@dennedy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PREFERENCES_H
#define PREFERENCES_H 1

#include <gnome.h>

enum { AVI, PLAYLIST, UNKNOWN_FORMAT };
enum { PAL_FORMAT, NTSC_FORMAT, AVI_DV1_FORMAT, AVI_DV2_FORMAT, QT_FORMAT, RAW_FORMAT, TEST_FORMAT, UNDEFINED };
enum { DISPLAY_XX, DISPLAY_GDKRGB, DISPLAY_GDKRGB32, DISPLAY_XV, DISPLAY_SDL };

/// Load and save user options

class Preferences {
private:
	static Preferences *instance;

protected:
    Preferences();

public:
    static Preferences &getInstance();

    gchar file[512];
    gint fileFormat;
    gboolean autoSplit;
    gboolean timeStamp;
    gint frames;
    gint every;
    gint interface;
    gint channel;
    gint phyID;
    gint displayMode;
    gfloat displayQuality;
    gboolean enableAudio;
    guint cip_n;
    guint cip_d;
    guint syt_offset;
    gboolean preview_capture;
    gboolean dropFrame;
    gchar *audioDevice;
    gboolean enableJogShuttle;
    gchar *jogShuttleDevice;
	gboolean enableV4L;
	gboolean disableKeyRepeat;
	gint audioRendering;
	gint previewRendering;
	gboolean enableTimecode;

    void Save();
};

extern "C" gchar *Preferences_getAudioDevice(void);

#endif

