/*
 * page_bttv.h Notebook v4l Capture (?) Page Object
 * Copyright (C) 2001 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//#define _NO_VIDEO4LINUX_

#ifndef _PAGE_BTTV_H
#define _PAGE_BTTV_H

#include "kino_common.h"
#include "page.h"

#ifdef _NO_VIDEO4LINUX_

class PageBttv : public Page {
	private:
		KinoCommon *common;
	public:
		PageBttv( KinoCommon *common ) {
			this->common = common;
		}
		virtual ~PageBttv() {
		}
};

#else

#include "displayer.h"
#include "v4l.h"

/** Video4Linux Capture page. Totally disconnected from the rest of the app.

	Curious if I can generate a Frame object to allow playback using 
	FrameDisplayer but will require virtual methods on the base class... maybe 
	withdrawn if no one is interested (or proves too difficult).

	Silly behaviour - uses Rewind and Fast Forward as channel hopper, start/end
   	of scene for large frequency jumps (+/- 100) and back/forward as fine 
	tuning. Produces a report on the capability of your video capture card on 
	stdout and then promptly ignores everything that it's found out about it ...
   	yippee.

	Only tested on hauppage BT878 - no idea about other cards, though will be 
	able to test on an iomega buz at some point.
*/

class PageBttv : public Page {
	private:
		// Imported
		KinoCommon *common;

		// Video4Linux object
		GDKV4L *v4l;

	public:
		PageBttv( KinoCommon *common ) { 
			this->common = common;
		}

		virtual ~PageBttv() {
		}

		void start() {
			cout << ">>> Starting bttv" << endl;
			v4l = new GDKV4L( lookup_widget( common->getWidget(), "drawingarea3" ) );
			if ( v4l->deviceAvailable() ) {
				v4l->report();
				v4l->setChannel( 0 );
				v4l->setTuner( 0 );
				v4l->startAudio();
				v4l->startVideo();
			}
			else {
				cout << "unable to open video device" << endl;
			}
		}

		gulong activate() {
			if ( v4l->deviceAvailable() ) 
				return VIDEO_START_OF_SCENE | VIDEO_REWIND | VIDEO_BACK | 
				   	   VIDEO_PLAY | VIDEO_STOP | 
					   VIDEO_FAST_FORWARD | VIDEO_FORWARD | VIDEO_NEXT_SCENE;
			else
				return 0;
		}

		void clean() {
			if ( v4l->deviceAvailable() ) {
				v4l->stopVideo();
				v4l->stopAudio();
			}
			delete v4l;
			v4l = NULL;
		}

		void StartOfMovie() {
			v4l->setFrequency( 0 );
		}

		void videoPreviousScene() {
			v4l->setFrequency( v4l->getFrequency() - 100 );
		}

		void videoRewind() {
			do {
				v4l->setFrequency( v4l->getFrequency() - 1 );
			}
			while( v4l->getSignal() != 0 );
			do {
				v4l->setFrequency( v4l->getFrequency() - 2 );
			}
			while( v4l->getSignal() == 0 );
		}

		void videoPlay() {
			v4l->startVideo();
		}

		void videoStop() {
			v4l->stopVideo();
		}

		void videoFastForward() {
			do {
				v4l->setFrequency( v4l->getFrequency() + 1 );
			}
			while( v4l->getSignal() != 0 );
			do {
				v4l->setFrequency( v4l->getFrequency() + 2 );
			}
			while( v4l->getSignal() == 0 );
		}

		void videoBack() {
			v4l->setFrequency( v4l->getFrequency() - 1 );
		}

		void videoForward() {
			v4l->setFrequency( v4l->getFrequency() + 1 );
		}

		void videoNextScene() {
			v4l->setFrequency( v4l->getFrequency() + 100 );
		}

		void windowChanged() {
			v4l->windowMoved();
		}

		void visibilityChanged( gboolean visible ) {
			v4l->visibilityChanged( visible );
		}
};

#endif

#endif
