/*
 *
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// GUI Page Handling Code
#include "kino_common.h"
#include "page.h"
#include "page_editor.h"
#include "page_capture.h"
#include "page_timeline.h"
#include "page_export.h"

#include "preferences.h"
#include "riff.h"
#include "avi.h"
#include "filehandler.h"
#include "ieee1394io.h"
#include "message.h"
#include "bar.h"
#include "jogshuttle.h"

#include <iostream>
using std::cout;
using std::endl;

extern "C" {

#include <sys/stat.h>
#include <sys/time.h>
#include <gnome.h>
#include <math.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "commands.h"
#include "progress_dialog.h"
#include "jogshuttle.h"

	extern struct navigate_control g_nav_ctl;

	KinoCommon *common;

	void kinoInitialise( GtkWidget *widget )
	{
		/* take care of stuff Glade can not do */
		/* connect adjustements to range widgets */
		GtkWidget *hscale = lookup_widget (widget, "frame_pos");
		gtk_signal_connect (GTK_OBJECT (GTK_RANGE (hscale)->adjustment),
                      "value_changed", GTK_SIGNAL_FUNC (on_frame_pos_value_changed_event),
                      NULL);

		hscale = lookup_widget (widget, "hscale_shuttle");
		GtkAdjustment *adjust = GTK_RANGE(hscale)->adjustment;
		adjust->lower = -7;
		adjust->upper = 8;
		adjust->value = 0;
		adjust->step_increment = 1;
		adjust->page_increment = 7;
		adjust->page_size = 1;
		gtk_signal_emit_by_name( GTK_OBJECT( adjust ), "changed" );
		gtk_adjustment_set_value( adjust, 0 );
		gtk_signal_connect (GTK_OBJECT (adjust),
                      "value_changed", GTK_SIGNAL_FUNC (on_hscale_shuttle_value_changed_event),
                      NULL);

		hscale = lookup_widget (widget, "hscale_export_stills");
		gtk_signal_connect (GTK_OBJECT (GTK_RANGE (hscale)->adjustment),
                      "value_changed", GTK_SIGNAL_FUNC (on_hscale_export_stills_value_changed_event),
                      NULL);

		common = new KinoCommon( widget );
		new JogShuttle( widget );
		if ( !common->getConfig().enableV4L )
			gtk_notebook_remove_page( GTK_NOTEBOOK( lookup_widget( widget, "main_notebook" ) ), PAGE_BTTV );
	}

	void kinoDeactivate() 
	{
		delete common;
		gtk_exit(0);
	}

	void refresh( ) {
		common->moveToFrame( );
	}

	void newFile( ) {
		common->newFile();
	}

	void openFile( )
	{
		common->loadFile();
	}

	void savePlayListAs( )
	{
		common->savePlayListAs();
	}
	
	void savePlayList( )
	{
		common->savePlayList();
	}

	void saveMovie( )
	{
		common->saveMovie();
	}

	void saveFrame( )
	{
		common->saveFrame();
	}
	
	void insertFile( )
	{
		common->insertFile();
	}
	
	void appendFile( )
	{
		common->appendFile();
	}

	void pageStart( int page )
	{
		common->setCurrentPage( page );
	}

	void videoStart( )
	{
		common->videoStartOfMovie();
	}

	void videoPreviousScene( )
	{
		common->videoPreviousScene();
	}

	void videoStartOfScene( )
	{
		common->videoStartOfScene();
	}

	void videoRewind( )
	{
		common->videoRewind();
	}

	void videoBack( )
	{
		common->videoBack();
	}

	void videoPlay( )
	{
		common->videoPlay();
	}

	void videoForward( )
	{
		common->videoForward();
	}

	void videoFastForward( )
	{
		common->videoFastForward();
	}

	void videoNextScene( )
	{
		common->videoNextScene();
	}

	void videoEndOfScene( )
	{
		common->videoEndOfScene();
	}

	void videoEndOfMovie( )
	{
		common->videoEndOfMovie();
	}

	void videoStop( )
	{
		common->videoStop();
	}

	void videoPause( )
	{
		common->videoPause();
	}

	void videoShuttle( int angle )
	{
		common->videoShuttle( angle );
	}

	void windowChanged()
	{
		common->windowChanged();
	}

	void windowMoved()
	{
		common->windowMoved();
	}

	void visibilityChanged( gboolean visible )
	{
		common->visibilityChanged( visible );
	}

	void notebookChangePage( int page )
	{
		common->changePageRequest( page );
	}

	gboolean processKeyboard( GdkEventKey *event ) 
	{
		// To avoid problems with repeat keys only process 
		// top of the event queue key presses - issue is that
		// we don't know if any pending event is actually a 
		// keypress... think all key press should move over to
		// a snoop, but even then.. dunno if that'll help
		if ( common->getConfig().disableKeyRepeat && gdk_events_pending() )
			return FALSE;

		return common->processKeyboard( event );
	}

	void processCommandLine( char *command ) 
	{
		common->processCommandLine( command );
	}

	void processMenuCommand( char *command )
	{
		common->processMenuCommand( command );
	}

	void selectScene( int i )
	{
		common->selectScene( i );
	}
	
	void startCapture( void )
	{
		common->getPageCapture()->startCapture();
	}

	void stopCapture( void )
	{
		common->getPageCapture()->stopCapture();
	}

	void view50percent( void ) {
		common->view50percent();
	}

	void view100percent( void ) {
		common->view100percent();
	}

	void toggleShowInfo( void ) {
		common->toggleShowInfo();
	}

	void startExport( void )
	{
		common->getPageExport()->startExport();
	}

	void stopExport( void )
	{
		common->getPageExport()->stopExport();
	}

	void setExportMode( int mode )
	{
		common->getPageExport()->setCurrentMode( mode );
	}

	// Deprecated and/or non-migrated functions
	//

	int moveToFrame( int frame )
	{
		return common->moveToFrame( frame );
	}

	void stop_navigator(void)
	{
		common->getPageEditor()->videoStop();
	}

	int Play(GtkWidget *drawingarea, int first, int last, gboolean no_audio) {

		int currentFrame;

		if (common->getPlayList()->GetNumFrames() == 0)
			return -1;

		if (first < 0)
			first = 0;
		if (first >= common->getPlayList()->GetNumFrames())
			first = common->getPlayList()->GetNumFrames() - 1;
		if (last < 0)
			last = 0;
		if (last >= common->getPlayList()->GetNumFrames())
			last = common->getPlayList()->GetNumFrames() - 1;

		if (first <= last) {

			currentFrame = first;
			// struct timeval tv;
			// gettimeofday(&tv, NULL);
			// long long starttime = tv.tv_sec * 1000000 + tv.tv_usec;
			for (int i = first; i <= last; ++i) {
				common->moveToFrame( i );
				currentFrame = i;
			}
			// gettimeofday(&tv, NULL);
			// long long endtime = tv.tv_sec * 1000000 + tv.tv_usec;
			// double fps = (last - first + 1) / (((double)(endtime - starttime)) / 1000000);
			// cout << "fps: " << fps << endl;
			return currentFrame;
		} else
			return -1;
	}

	void bulkLoad(int argc, char* argv[]) {
		common->bulkLoad( argc, argv );
	}

	void InitBar(GtkWidget *drawingarea, int currentFrame) {
		common->getPageEditor()->InitBar( currentFrame );
		common->showScenes( );
	}

	void DrawBar(GtkWidget *drawingarea, int currentFrame) {
		common->getPageEditor()->DrawBar( currentFrame );
	}

	void ResetBar(GtkWidget *drawingarea) {
		common->getPageEditor()->ResetBar( );
		common->showScenes( );
	}

	void RefreshBar( GtkWidget *drawingarea ) {
		common->getPageEditor()->RefreshBar( common->g_currentFrame );
	}

	void
	on_update_bar_activate				 (GtkMenuItem	 *menuitem,
											gpointer		 user_data) {
		GtkWidget *bar_drawable = lookup_widget(GTK_WIDGET(menuitem), "frame_pos");
		InitBar( bar_drawable, common->g_currentFrame );
	}
	
} // extern "C"
