/***************************************************************************
                             pluginsimp.h
                             -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef PLUGINSIMP_H
#define PLUGINSIMP_H

#include <plugins.h>
#include <qlist.h>
#include "pluginpriorityimp.h"

class BuddyListWindow;
class TAim;
class KinkattaPlugin;

/**
  *@author Benjamin Meyer
  */

class PluginsImp : public Plugins  {

Q_OBJECT
	
signals:

public:
  PluginsImp(QWidget *parent=0, const char *name=0);
  ~PluginsImp();
  void setPointers(BuddyListWindow *mainWindow, TAim *connection); 
  void saveSettings();

private slots:
  void okClicked();
  void priorityClicked();
  void loadPlugin( QString libFileName );
  void loadPluginButtonClicked();
  void unloadPlugin();
  void unloadPlugin( bool reload );
  void reloadPlugin();
  void buttonApplyClicked();
  void itemSelected(int index);
  void updatePriority(QList<KinkattaPlugin> plugins);

private:
  QList<KinkattaPlugin> plugins;
  TAim *connection;
  BuddyListWindow *mainWindow;
  void setUpConnections();
  QWidget *currentConfigure;
  PluginPriorityImp *priority;

};

#endif

// PluginsImp.h

