/***************************************************************************
                              debugwindow.cpp 
                           -------------------
    begin                : Sunday Jan 27 2002
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#include "debugwindow.h"
#include "configure.h"
#include <qpushbutton.h>
#include <qmultilineedit.h>
#include "taim.h"

extern "C"
{
  void* create_plugin()
  {
    return new DebugWindow;
  }
};

/**
 * Constructor.  Initializes the plugin info and settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
DebugWindow::DebugWindow(QWidget *parent, const char *name) : KinkattaPlugin( parent,name ){
  info.Name = "Debug Window";
  info.Author = "Benjamin Meyer";
  info.Version = "1.00";
  info.HomePage = "http://kinkatta.sourceforge.net/";

  debugWindow = NULL;
  configureWidget = NULL;
}

/**
 * Reads in the settings.
 */
void DebugWindow::initPlugin(){
  connect(connection, SIGNAL(debugDataIn(QString)), this, SLOT(debugDataIn(QString)));
}
 
/**
 * Creates the configure widget if there isn't one.
 * @param parent the parent widget for the configure widget if one needs to be made.
 * @return QWidget the configure widget for this plugin.
 */
QWidget *DebugWindow::configure( QWidget *parent ){
  if ( configureWidget == NULL ){
    configureWidget = new Configure(parent, "Debug Window Configure window.");
    connect( configureWidget->showWindow, SIGNAL(clicked()), this, SLOT(showDebugWindow()));
  }
  return configureWidget;
}	

/**
 * Creates a debug window is there isn't one and displays it.
 */
void DebugWindow::showDebugWindow(){
  if ( debugWindow == NULL ){
    debugWindow = new QMultiLineEdit(0, "DebugWindow");
    debugWindow->setWordWrap( QMultiLineEdit::WidgetWidth );
    debugWindow->setWrapPolicy( QMultiLineEdit::Anywhere );
    debugWindow->setReadOnly(TRUE);
    debugWindow->setCaption("Kinkatta - Debug Window");
    debugWindow->resize(450,250);
    connect(debugWindow, SIGNAL(destroyed ()),this, SLOT( debugWindowDistroyed() ));
    debugWindow->show();
  }
  debugWindow->show();
}

/**
 * When the debug window is distroyed we set our pointer to NULL
 */
void DebugWindow::debugWindowDistroyed(){
  debugWindow = NULL;
}

/**
 * Data that is going in or out will be sent here for us to display if we want.
 * @Param data the string that is being sent in or out.
 */
void DebugWindow::debugDataIn( QString data ){
  if ( debugWindow != NULL ){
    debugWindow->append(data + "\n");
    debugWindow->setCursorPosition( debugWindow->numLines(), 0 );
    debugWindow->repaint(FALSE);
  }
}

// debugWindow.cpp

