/***************************************************************************
                             kinkattagaimplugin.h
                             -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTAGAMEPLUGIN_H
#define KINKATTAGAMEPLUGIN_H

#include <kinkattaplugin.h>
#include <qlist.h>

/**
 * Game struct.
 * @author Benjamin Meyer
 */

struct game{
  QString buddy;
  bool myTurn;
  bool gameInProgress;
  QWidget *board;
};


/**
 * A base class for a game.  It will handle connections etc so all you have to do
 * is make the game and call startGame, endGame and move.
 * @author Benjamin Meyer
 */

class KinkattaGamePlugin : public KinkattaPlugin {

Q_OBJECT
	
public:
  /// Constructor.
  KinkattaGamePlugin( QWidget *parent=0, const char *name=0, QString gameName=0 );
  
  /// Deconstructor.
  virtual ~KinkattaGamePlugin();

public slots:
  /// A message has come from the network for this plugin to handle.
  virtual void inChatMessage( QString buddy, QString message, bool isAuto );

  /// A message in going out for this plugin to handle.
  virtual void outChatMessage( QString buddy, QString message, bool isAuto, bool endIdleNess );
  
  /// After this plugin has been initialized this function is called.
  virtual void initPlugin();

protected slots:
  virtual void move(QString &theMove, QString buddy);
  virtual bool startGame(QString buddy);
  virtual void endGame(QString buddy);

protected:
  /// The name of the game.  Used in message passing.
  QString gameName;
  
  /// A list of games for multiple games.
  QList<game> games;
  
  /// Helper function that returns a game for a buddy. 
  game *findGame( QString buddy );

};

#endif

// kinkattagaimplugin.h

