/***************************************************************************
                                babel.cpp 
                           -------------------
    begin                : Tuesday Nov 11 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "babel.h"
#include <qwidget.h>
#include <qstring.h>
#include <kurl.h>
#include <unistd.h>
#include <qapplication.h>
#include <qregexp.h>

/**
 * Initializes the dialog and does signal-slot connection.
 * @param parent the parent widget
 * @param name the name of this widget
 */
Babel::Babel( QWidget *parent, const char *name ) : QSocket( parent, name ){
  connect( this, SIGNAL(connectionClosed()), this, SLOT(done())); 
  connect( this, SIGNAL(readyRead()), this, SLOT(incoming()));
  type = "en_fr";
  currentIn = 0;
  //translate("Hello there", "Benjamin", false);
}

/**
 * Does nothing.
 */
Babel::~Babel(){
}

/**
 * Using QSockets writeBlock send out the message.
 * @param message the text to send.
 */
void Babel::sendOut( QString message ){
  this->writeBlock( message.latin1(), message.length() );
}

/**
 * Translate a message.  If one is in progress, wait.  Otherwise start
 * the process with the server.
 * @param message the message to translate.
 * @param buddy the buddy the message is going to.
 * @param in once the message is done this determines with signal is emitted.
 */
void Babel::translate( QString message, QString buddy, bool in ){
  while(currentIn != 0){
    qApp->processEvents();
    sleep(1);
  }
  currentAttempt = message;
  message.replace(QRegExp(" "),"+");
  strip(message);
  //message = KURL::encode_string(message);
  currentBuddy = buddy;
  if( in == true )
    currentIn = 1;
  else
    currentIn = 2;
  this->connectToHost("babelfish.altavista.com", 80);
  sendOut("POST /translate.dyn HTTP/1.0\n"); 
  sendOut("Host: babelfish.altavista.com\n");
  sendOut("User-Agent: kinkatta\n");
  QString length = QString("Content-Length: %1\n").arg(60-17+message.length());
  sendOut(length);
  sendOut("Content-Type: application/x-www-form-urlencoded\n");
  sendOut("\n");
  QString word = "doit=done&bbltype=urltext&lp=";
  word += type;
  word += "&urltext=";
  word += message + "\n";
  sendOut(word);
}

/**
 * Append the new incoming data in the page.
 */
void Babel::incoming(){
  while( canReadLine() ){
    page += readLine() + "\n";
  }
}

/**
 * A full page was grabbed, find the translation and emit a signal.
 */
void Babel::done(){
  int q = page.find("name=\"q\"");
  if( q == -1 ){
    qDebug(page.latin1());
    QString out = "Could not translate(" + currentAttempt + ")";
    //if( currentIn == 1)
      emit (translatedIn( out, currentBuddy ));
    //else
    //  emit (translatedOut( out, currentBuddy ));
  }
  else{
    int end = page.find("<", q+9);
    QString out = page.mid((q+9), (end-q-11));
    qDebug(out.latin1());
    if( currentIn == 1)
      emit (translatedIn( out, currentBuddy ));
    else
      emit (translatedOut( out, currentBuddy ));
  }
  currentIn = 0;
  page = "";
}

/**
 * Sets the type of translation to be used (Ex: French->English)
 * @param newType can be any of the following:<br>
 * "en_zh" English to Chinese <br>
 * "en_fr" English to French<br>
 * "en_de" English to German<br>
 * "en_it" English to Italian<br>
 * "en_ja" English to Japanese<br>
 * "en_ko" English to Korean<br>
 * "en_pt" English to Portuguese<br>
 * "en_es" English to Spanish<br>
 * "zh_en" Chinese to English<br>
 * "fr_en" French to English<br>
 * "fr_de" French to German<br>
 * "de_en" German to English<br>
 * "de_fr" German to French<br>
 * "it_en" Italian to English<br>
 * "ja_en" Japanese to English<br>
 * "ko_en" Korean to English<br>
 * "pt_en" Portuguese to English<br>
 * "ru_en" Russian to English<br>
 * "es_en" Spanish to English<br>
 */
void Babel::setType( QString newType ){
  while(currentIn != 0){
    qApp->processEvents();
    sleep(1);
  }
  type = newType;
}

/**
 * Remove all html tags from a message.
 * @param message the text to strip the html from.
 */
void Babel::strip( QString &message ){
  int start = 0;
  int end = 0;
  while ( end!=-1 && start!=-1 ){
    start = message.find("<");
    end = message.find(">");
    if( end!=-1 && start!=-1 ){
      message.remove(start, end-start+1);
    }
  }
}

// babel.cpp

