/***************************************************************************
                               TextOptionsImp.h
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef TEXTOPTIONSIMP_H
#define TEXTOPTIONSIMP_H

#include <textoptions.h>
#include <setup.h>
class QFont;
class QColor;

/**
  *@author Benjamin Meyer
  */

class TextOptionsImp : public TextOptions  {

Q_OBJECT
	
signals:
  void saveSettings();

public:
  TextOptionsImp(QWidget *parent=0, const char *name=0);
  ~TextOptionsImp();

public slots:
  void updateData();
  void getData();

private slots:
  void changeUserTextColor();
  void changeBuddyTextColor();
  void changeUserNameColor();
  void changeBuddyNameColor();
  void changeBuddyBGColor();
  void changeUserBGColor();
  void setDefaultBuddyColors();
  void setDefaultUserColors();

private:
  settings_t *i_aimSettings;
  void getNewColor(QColor &c, QPushButton *l);

  QFont chat_yourFont;
  QFont chat_contactFont;

  QColor chat_yourText_color;
  QColor chat_yourName_color;
  QColor chat_contactText_color;
  QColor chat_contactName_color;
  QColor chat_yourbg_color;
  QColor chat_contactbg_color;

};

#endif

// TextOptionsImp.h

