/***************************************************************************
                             soundoptionsimp.cpp
                             -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : ben@meyerhome.net
 ***************************************************************************/


#include "soundoptionsimp.h"
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qfiledialog.h>
#include <qwidget.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kglobal.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
SoundOptionsImp::SoundOptionsImp(QWidget *parent, const char *name) : SoundOptions( parent,name,false ){
	i_aimSettings = setup::settings();
  connect(sound_browse_login, SIGNAL(clicked()), this, SLOT(setBuddyLoginClicked()));
  connect(sound_browse_logout, SIGNAL(clicked()), this, SLOT(setBuddyLogoutClicked()));
  connect(sound_browse_initial, SIGNAL(clicked()), this, SLOT(setInitialClicked()));
  connect(sound_browse_send, SIGNAL(clicked()), this, SLOT(setSendClicked()));
  connect(sound_browse_receive, SIGNAL(clicked()), this, SLOT(setReceiveClicked()));
  connect(default_sounds, SIGNAL(clicked()), this, SLOT(setDefaultSounds())); 
  connect(default_player, SIGNAL(clicked()), this, SLOT(setDefaultPlayer())); 
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
SoundOptionsImp::~SoundOptionsImp(){
}

/******************************************************************************
 * Set the default player command
 ******************************************************************************/
void SoundOptionsImp::setDefaultPlayer(){
  sound_file_command->setText("play");
}


/******************************************************************************
 * Set the sound paths to the default install paths.
 ******************************************************************************/
void SoundOptionsImp::setDefaultSounds(){
  sound_file_send->setText(DATADIR "/sounds/Send.au");
  sound_file_receive->setText(DATADIR "/sounds/Receive.au");
  sound_file_initial->setText(DATADIR "/sounds/Receive.au");
  sound_file_login->setText(DATADIR "/sounds/BuddyArrive.au");
  sound_file_logout->setText(DATADIR "/sounds/BuddyLeave.au");
}
 
/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void SoundOptionsImp::updateData(){
  i_aimSettings = setup::settings();

  mode_soundcard->setChecked(true);
	
  if ( i_aimSettings->SoundMode == 0)
    mode_soundcard->setChecked(true);

  if ( i_aimSettings->SoundMode == 1)
    mode_beep->setChecked(true);
  if ( i_aimSettings->SoundMode == 2)
    mode_nosound->setChecked(true);

  KConfig &config = *KGlobal::config();
  config.setGroup("chatwindow");

   
  sound_enable_login->setChecked(i_aimSettings->sound_enable_login);
  sound_enable_logout->setChecked(i_aimSettings->sound_enable_logout);
  sound_enable_initial->setChecked(config.readBoolEntry( "chat_sound_beepInitial", true ));  
  sound_enable_receive->setChecked(config.readBoolEntry( "chat_sound_beepReceive", true ));
  sound_enable_send->setChecked(config.readBoolEntry( "chat_sound_beepSend", true ));
  sound_file_send->setText(config.readEntry( "chat_sound_fileSend", DATADIR "/sounds/Send.au" ));
  sound_file_receive->setText(config.readEntry( "chat_sound_fileReceive", DATADIR "/sounds/Receive.au" ));
  sound_file_initial->setText(config.readEntry( "chat_sound_fileInitial", DATADIR "/sounds/Receive.au" ));
   
  sound_file_login->setText(i_aimSettings->sound_file_login);
  sound_file_logout->setText(i_aimSettings->sound_file_logout);

  sound_file_command->setText(i_aimSettings->sound_file_command);

  sound_disableWhenAway->setChecked(i_aimSettings->away_disable_sound);
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void SoundOptionsImp::getData(){
  KConfig &config = *KGlobal::config();
  config.setGroup("chatwindow");

  if ( mode_soundcard->isChecked()){
    i_aimSettings->SoundMode = 0;
    config.writeEntry("chat_sound_playFile", true);
    config.writeEntry("chat_sound", true);
  }	
  if ( mode_beep->isChecked()){
    i_aimSettings->SoundMode = 1;
    config.writeEntry("chat_sound_playFile", false);
    config.writeEntry("chat_sound", true);
  }  
  if ( mode_nosound->isChecked()){
    i_aimSettings->SoundMode = 2;
    config.writeEntry("chat_sound_playFile", false);
    config.writeEntry("chat_sound", false);
  }

  config.writeEntry("chat_sound_beepInitial", sound_enable_initial->isChecked());
  config.writeEntry("chat_sound_beepReceive", sound_enable_receive->isChecked());
  config.writeEntry("chat_sound_beepSend", sound_enable_send->isChecked());
  config.writeEntry("chat_sound_fileSend", sound_file_send->text());
  config.writeEntry("chat_sound_fileReceive", sound_file_receive->text());
  config.writeEntry("chat_sound_fileInitial", sound_file_initial->text());
  
  i_aimSettings->sound_enable_login = sound_enable_login->isChecked();
  i_aimSettings->sound_enable_logout = sound_enable_logout->isChecked();
  i_aimSettings->sound_file_command = sound_file_command->text();
  i_aimSettings->sound_file_login = sound_file_login->text();
  i_aimSettings->sound_file_logout = sound_file_logout->text();

  if ((sound_enable_receive->isChecked() == false) && (sound_enable_send->isChecked() == false) && (sound_enable_initial->isChecked() == false))
    config.writeEntry("chat_sound", false);

  i_aimSettings->away_disable_sound = sound_disableWhenAway->isChecked();
}

void SoundOptionsImp::setBuddyLoginClicked(){
  QString s( KFileDialog::getOpenFileName( QString(""),QString("*.wav *.au"),this, "Multimedia Files (*.au *.wav)") );
  if ( s.isEmpty()) return;
	else sound_file_login->setText(s);
}

void SoundOptionsImp::setBuddyLogoutClicked(){
  QString s( KFileDialog::getOpenFileName( QString(""),QString("*.wav *.au"),this, "Multimedia Files (*.au *.wav)") );
  if ( s.isEmpty()) return;
	else sound_file_logout->setText(s);
}

void SoundOptionsImp::setInitialClicked(){
  QString s( KFileDialog::getOpenFileName( QString(""),QString("*.wav *.au"),this, "Multimedia Files (*.au *.wav)") );
  if ( s.isEmpty()) return;
	else sound_file_initial->setText(s);
}

void SoundOptionsImp::setSendClicked(){
  QString s( KFileDialog::getOpenFileName( QString(""),QString("*.wav *.au"),this, "Multimedia Files (*.au *.wav)") );
  if ( s.isEmpty()) return;
	else sound_file_send->setText(s);
}

void SoundOptionsImp::setReceiveClicked(){
  QString s( KFileDialog::getOpenFileName( QString(""),QString("*.wav *.au"),this, "Multimedia Files (*.au *.wav)") );
  if ( s.isEmpty()) return;
	else sound_file_receive->setText(s);
}

// SoundOptionsImp.cpp
