/***************************************************************************
                               options.h
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef OPTIONS_H
#define OPTIONS_H

#include <qvariant.h>
#include <kdialog.h>
#include <qlistbox.h>

class ChatOptionsImp;
class AwayWindowOptionsImp;
class MainWindowOptionsImp;
class ProfileOptionsImp;
class SoundOptionsImp;
class NetworkOptionsImp;
class PermitDenyOptionsImp;
class TextOptionsImp;
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QListBox;
class QLabel;
class QListBoxItem;
class QPushButton;
class QFrame;
 
#include "setup.h"
#include "taim.h"

class IconListItem : public QListBoxItem{
  public:
    IconListItem( QListBox *listbox, const QPixmap &pixmap, const QString &text );
    virtual int height( const QListBox *lb ) const;
    virtual int width( const QListBox *lb ) const;
    int expandMinimumWidth( int width );

  protected:
    const QPixmap &defaultPixmap();
    void paint( QPainter *painter );

  private:
    QPixmap mPixmap;
    int mMinimumWidth;
};

/**
 * Options widget that contains all of the options widgets.
 * @author Benjamin Meyer
 */ 
class Options : public KDialog{ 
Q_OBJECT

signals:
  void chatToolbarUpdated();
  void chatRoomToolbarUpdated();

  void dataUpdated();
  void exiting();

public:
  Options( QWidget* parent = 0, const char* name = 0, TAim *i_connection=0, bool modal = FALSE, WFlags fl = 0 );
  ~Options();

  QListBox* listBox;
  QPushButton* buttonDefault;
  QPushButton* buttonApply;
  QPushButton* buttonOk;
  QPushButton* buttonCancel;
  QFrame* line;
  QFrame* line2;
  QLabel* title;
	
public slots:
  void updateData();

private slots:
  void okClicked();
  void cancelClicked();
  void applyClicked();
  void defaultClicked();
  void optionIconSelected();
	
private:
  settings_t *i_aimSettings;
  SoundOptionsImp *sound;
  NetworkOptionsImp *network;
  AwayWindowOptionsImp *away;
  PermitDenyOptionsImp *deny;
  ProfileOptionsImp *profile;
  ChatOptionsImp *chat;
  MainWindowOptionsImp *main;
  TextOptionsImp *text;
	
  IconListItem *item1;
  IconListItem *item2;
  IconListItem *item3;
  IconListItem *item4;
  IconListItem *item5;
  IconListItem *item6;
  IconListItem *item7;
  IconListItem *item8;
		

	
protected:
  QHBoxLayout* LayoutItem;
	QVBoxLayout* LayoutGlobal;
  QHBoxLayout* Layout1;
  QVBoxLayout* LayoutHelpWLine;
	QVBoxLayout* LayoutItemWHeader;
	
};

#endif // OPTIONS_H




