/***************************************************************************
                               ChatOptionsImp.cpp
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "chatoptionsimp.h"
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kfontdialog.h>
#include <qfont.h>
#include <qlabel.h>
#include <qapplication.h>
#include <qpushbutton.h>

/**
 * Constructor
 */
ChatOptionsImp::ChatOptionsImp(QWidget *parent, const char *name) : ChatOptions ( parent,name,false ){
}

/**
 * Copy the settings to the widgets.
 */
void ChatOptionsImp::updateData(){
  // Get settings.
  KConfig &config = *KGlobal::config();
  config.setGroup("chatwindow");
  chat_message_flash->setChecked(config.readBoolEntry("chat_flash_on_new_message", true));
  chat_message_raise->setChecked(config.readBoolEntry("chat_raise_window", true));
  chat_log_everything->setChecked(config.readBoolEntry("chat_log", true));
  chat_log_html->setChecked(config.readBoolEntry("chat_log_inHtml", true));
  chat_log_single_file->setChecked(config.readBoolEntry("chat_log_singleFile", false));
  chat_show_time->setChecked(config.readBoolEntry("chat_show_time", true));
  chat_log_time->setChecked(config.readBoolEntry("chat_log_time", true));
  chat_send_return->setChecked(config.readBoolEntry("chat_return_send", true));
  chat_send_shift->setChecked(config.readBoolEntry("chat_sreturn_send", false));
  chat_send_blank->setChecked(config.readBoolEntry("chat_send_blank", false));
  chat_remove_tages->setChecked(config.readBoolEntry("chat_ignore_contacthtml", false));
  chat_show_smilies->setChecked(config.readBoolEntry("chat_show_smilies", true));
  chat_conversation_limit->setChecked(config.readBoolEntry("chat_line_limit",false));
  if (config.readBoolEntry("chat_line_limit", false) == true)
    chat_conversation_limit_number->setEnabled(true);
  else
    chat_conversation_limit_number->setEnabled(false);
  chat_conversation_limit_number->setValue(config.readNumEntry("chat_line_limit_number", 500));

  QFont defaultFont = qApp->font();
  defaultFont.setPointSize(12);
  chat_yourFont = config.readFontEntry( "chat_yourFont", &defaultFont );
  chat_contactFont = config.readFontEntry( "chat_contactFont", &defaultFont );
  updateLabel(TextLabel_yourFont, chat_yourFont);
  updateLabel(TextLabel_buddyFont, chat_contactFont);

  connect(yourFont_change, SIGNAL(clicked()), this, SLOT(changeUserFont()));
  connect(buddyFont_change, SIGNAL(clicked()), this, SLOT(changeBuddyFont()));
  connect(yourFont_default, SIGNAL(clicked()), this, SLOT(setDefaultUserFont()));
  connect(buddyFont_default, SIGNAL(clicked()), this, SLOT(setDefaultBuddyFont()));
 
}

/**
 * Helper function.  Sets a button to have a font 'f'
 * @param l label to fill.
 * @param f font to user.
 */
void ChatOptionsImp::updateLabel( QLabel *l, const QFont &f ){
  l->setFont( f );
  l->setText( f.family() + " " + QString::number(f.pointSize()) + "pt");
}

/**
 * Font Dialog function
 */
void ChatOptionsImp::updateFontSetting(QFont &f, QLabel *l){
  if( KFontDialog::getFont(f, false, this) )
    updateLabel(l, f);
}

/**
 * Bring up the dialog to change the users font.
 */
void ChatOptionsImp::changeUserFont(){
  updateFontSetting(chat_yourFont, TextLabel_yourFont);
}


/**
 * Bring up the dialog to change the buddy font.
 */
void ChatOptionsImp::changeBuddyFont(){
  updateFontSetting(chat_contactFont, TextLabel_buddyFont);
}

/**
 * Set the default user Font
 */
void ChatOptionsImp::setDefaultUserFont(){
  QFont tempFont;
  tempFont = qApp->font();
  tempFont.setPointSize(12);
  chat_yourFont = tempFont;
  updateLabel(TextLabel_yourFont, tempFont);
}

/**
 * Set the default buddy Font
 */
void ChatOptionsImp::setDefaultBuddyFont(){
  QFont tempFont;
  tempFont = qApp->font();
  tempFont.setPointSize(12);
  chat_contactFont = tempFont;
  updateLabel(TextLabel_buddyFont, tempFont);
}

/**
 * Copy the settings from the widgets to the settings
 */
void ChatOptionsImp::getData(){
  KConfig &config = *KGlobal::config();
  config.setGroup("chatwindow");
  config.writeEntry("chat_raise_window", chat_message_raise->isChecked());
  config.writeEntry("chat_flash_on_new_message", chat_message_flash->isChecked());
  config.writeEntry("chat_log", chat_log_everything->isChecked());
  config.writeEntry("chat_log_inHtml", chat_log_html->isChecked());
  config.writeEntry("chat_log_singleFile", chat_log_single_file->isChecked());
  config.writeEntry("chat_show_time", chat_show_time->isChecked());
  config.writeEntry("chat_log_time", chat_log_time->isChecked());
  config.writeEntry("chat_return_send", chat_send_return->isChecked());
  config.writeEntry("chat_sreturn_send", chat_send_shift->isChecked());
  config.writeEntry("chat_send_blank", chat_send_blank->isChecked());
  config.writeEntry("chat_ignore_contacthtml", chat_remove_tages->isChecked());
  config.writeEntry("chat_show_smilies", chat_show_smilies->isChecked());
  config.writeEntry("chat_line_limit", chat_conversation_limit->isChecked());
  config.writeEntry("chat_line_limit_number", chat_conversation_limit_number->value());
  config.writeEntry("chat_log", chat_log_everything->isChecked());
  config.writeEntry( "chat_yourFont", chat_yourFont );
  config.writeEntry( "chat_contactFont", chat_contactFont );
}

//ChatOptionsImp.cpp

