/***************************************************************************
                               newpounceimp.cpp
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "newpounceimp.h"
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include <qstring.h>

/**
 * Creates a new pounce for the buddy specified by name.  First
 * initializes the parent class in order to create the dialog.  The
 * options for the dialog are then set.  Connects the cancel button
 * signal.
 * @param parent the parent widget
 * @param name the name of the widget
 * @param pounceName the name of the pounce
 */
NewPounceImp::NewPounceImp(QWidget *parent, const char *name, 
			   QString pounceName) 
  : NewPounce( parent,name,false,WDestructiveClose ){

  if (pounceName.length() > 0)
    buddyName->insertItem(pounceName, -1); 
  
  event_signOn->setChecked(true);
  action_openChatWindow->setChecked(true);
  action_sendMessage->setChecked(true);
  action_doCommand->setChecked(false);
  action_command->setEnabled(false);
  action_message->setText("Pounce: ");
  connect(buttonCancel, SIGNAL(clicked()), this, SLOT(cancelAndClose()));
}

/**
 * Does nothing.
 */
NewPounceImp::~NewPounceImp(){
}

/**
 * Copy the settings from the form.  Before copying the data, each
 * item is verified.  If the form is not properly filled out, a
 * message is displayed for the user, the values are not copied, and
 * the dialog is not closed.  If everything is in order, the values
 * are copied and the dialog is closed.
 */
void NewPounceImp::verify(){
  bool close = true;
  if (buddyName->currentText() == QString("")){
    // Please put in buddyname
    QMessageBox::critical(this, "Kinkatta - Error","Please enter a buddy to pounce.", "Ok");
    close = false;	
  }
  if (event_signOn->isChecked() == false &&
      event_returnFromAway->isChecked() == false &&
      event_returnFromIdle->isChecked() == false){
    // Please choose an event
    QMessageBox::critical(this, "Kinkatta - Error","Please choose an event.", "Ok");
    close = false;	
  }
  if (action_openChatWindow->isChecked() == false &&
      action_sendMessage->isChecked() == false &&
			action_doCommand->isChecked() == false ){
    // Please choose an action
    QMessageBox::critical(this, "Kinkatta - Error","Please choose an action.", "Ok");
    close = false;
  }      
  if (action_sendMessage->isChecked() == true && action_message->text() == QString("")){
    // Please put in a message
    QMessageBox::critical(this, "Kinkatta - Error","Please put in a message.", "Ok");
    close = false;
  }
	if (action_doCommand->isChecked() == true && action_command->text() == QString("")){
    // Please put in a message
    QMessageBox::critical(this, "Kinkatta - Error","Please put in a command.", "Ok");
    close = false;
  }

  if (close == true){
    pounce newPounceStruct;
    newPounceStruct.buddyName = buddyName->currentText();
    newPounceStruct.signOn = event_signOn->isChecked();
    newPounceStruct.returnAway = event_returnFromAway->isChecked();
    newPounceStruct.returnIdle = event_returnFromIdle->isChecked();
    newPounceStruct.openChat = action_openChatWindow->isChecked();
    newPounceStruct.sendMessage = action_sendMessage->isChecked();
    newPounceStruct.message = action_message->text();
    newPounceStruct.execCommand = action_doCommand->isChecked();
    newPounceStruct.command = action_command->text();
    newPounceStruct.doNotRemove = doNotRemove->isChecked();
    newPounceStruct.deleteMenuId = -1;
    newPounceStruct.editMenuId = -1;
    newPounceStruct.hidden = false;
    emit addPounce(newPounceStruct);
    //close window.
    done(1);
  }
}

/**
 * Sets the window pounce information for this pounce.
 * @param newpounce the pounce to set
 */
void NewPounceImp::setPounce(pounce *newpounce){
  buddyName->insertItem(newpounce->buddyName, -1);
  event_signOn->setChecked(newpounce->signOn);
  event_returnFromAway->setChecked(newpounce->returnAway);
  event_returnFromIdle->setChecked(newpounce->returnIdle);
  action_openChatWindow->setChecked(newpounce->openChat);
  action_sendMessage->setChecked(newpounce->sendMessage);
  action_message->setText(newpounce->message);
  action_doCommand->setChecked(newpounce->execCommand);
  action_command->setText(newpounce->command);
  doNotRemove->setChecked(newpounce->doNotRemove);
}

/**
 * Close the window.
 */
void NewPounceImp::cancelAndClose(){
  done(1);
}

// PounceImp.cpp
