/***************************************************************************
                          newawaymessage.cpp  -  description
                             -------------------
    begin                : Tue Apr 11 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "newawaymessage.h"
#include <qmessagebox.h>

/**
 * Creates the QDialog parent, initializes the dialog, and connects
 * the OK and Cancel buttons.
 * @param parent the parent widget
 * @param name the name of the widget
 */
NewAwayMessage::NewAwayMessage(QWidget *parent, const char *name) : KDialog(parent,name,false,WDestructiveClose){
  i_aimSettings = setup::settings();
		
  initDialog();
	
  connect(cancel, SIGNAL(clicked()), this, SLOT(cancelClicked()));
  connect(ok, SIGNAL(clicked()), this, SLOT(okClicked()));
}

/**
 * Does nothing remarkable.
 */
NewAwayMessage::~NewAwayMessage(){
}

/**
 * Checks that the message and title of this away message are set.
 * Stores the message in the settings structure.  Sends a signal to
 * tell the buddy list to chat with this user and close the window.
 */
void NewAwayMessage::okClicked(){
  if (message->text().isEmpty() ){
    QMessageBox::information(this, "Kinkatta - Message",("You must have a message."), QMessageBox::Ok);
    return;
  }
  if (title->text().isEmpty() ){
    QMessageBox::information(this, "Kinkatta - Message",("You must have a title."), QMessageBox::Ok);
    return;
  }

  QString text = message->text();
  QString lastLetter = text.mid(text.length()-1,1);
  while (text.length() > 0 && lastLetter == "\n"){
    text = text.mid(0,text.length()-1);
    lastLetter = text.at(text.length()-1);
  }
  message->setText(text);

  //emit (ChatWithBuddyConfermed(UserName->text()));
  i_aimSettings->mapAwayMessages->insert(title->text(), message->text());
  emit(saveSettings());
  if (setAwayNow->isChecked()){
    emit (makeAwayNow(title->text()));
  }
  this->done(1);
}

/**
 * Closes the window and cancels the connect
 * Occurs when the Cancel Button is hit.
 */
void NewAwayMessage::cancelClicked(){
  this->done(1);
}

/**
 * Initializes the dialog.  Creates and configures the widgets.
 */
void  NewAwayMessage::initDialog(){
    resize( 298, 275 );
    setCaption( tr( "Kinkatta - New Away Message" ) );
    Form1Layout = new QVBoxLayout( this ); 
    Form1Layout->setSpacing( 6 );
    Form1Layout->setMargin( 11 );

    Layout6 = new QHBoxLayout; 
    Layout6->setSpacing( 6 );
    Layout6->setMargin( 0 );

    TextLabelTitle = new QLabel( this, "TextLabelTitle" );
    TextLabelTitle->setText( tr( "Title" ) );
    Layout6->addWidget( TextLabelTitle );

    title = new QLineEdit( this, "title" );
    Layout6->addWidget( title );
    Form1Layout->addLayout( Layout6 );

    message = new QMultiLineEdit( this, "message" );
    message->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, message->sizePolicy().hasHeightForWidth() ) );
    message->setWordWrap( QMultiLineEdit::WidgetWidth );
    message->setWrapColumnOrWidth( -1 );
    message->setWrapPolicy( QMultiLineEdit::AtWhiteSpace );
    Form1Layout->addWidget( message );

    Layout5 = new QVBoxLayout; 
    Layout5->setSpacing( 6 );
    Layout5->setMargin( 0 );

    TextLabel_n = new QLabel( this, "TextLabel_n" );
    TextLabel_n->setText( tr( "%n Name of buddy message is going to." ) );
    Layout5->addWidget( TextLabel_n );

    Layout4 = new QHBoxLayout; 
    Layout4->setSpacing( 6 );
    Layout4->setMargin( 0 );

    TextLabel_d = new QLabel( this, "TextLabel_d" );
    TextLabel_d->setText( tr( "%d Current Date." ) );
    Layout4->addWidget( TextLabel_d );

    TextLabel_t = new QLabel( this, "TextLabel_t" );
    TextLabel_t->setText( tr( "%t Current Time." ) );
    Layout4->addWidget( TextLabel_t );
    Layout5->addLayout( Layout4 );
    Form1Layout->addLayout( Layout5 );

    Layout12 = new QHBoxLayout; 
    Layout12->setSpacing( 6 );
    Layout12->setMargin( 0 );

    setAwayNow = new QCheckBox( this, "setAwayNow" );
    setAwayNow->setText( tr( "Set away now" ) );
		setAwayNow->setChecked(true);
    Layout12->addWidget( setAwayNow );

    ok = new QPushButton( this, "ok" );
    ok->setText( tr( "Ok" ) );
    Layout12->addWidget( ok );

    cancel = new QPushButton( this, "cancel" );
    cancel->setText( tr( "Cancel" ) );
    Layout12->addWidget( cancel );
    Form1Layout->addLayout( Layout12 );

}
#include "newawaymessage.moc"
// newawaymessage.cpp
