/******************************************************************************
                                chatroom.cpp
                             -------------------
    begin                : Wednesdat May 28 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben@meyerhome.net
 ******************************************************************************/

#include "chatroom.h"
#include "controlimp.h"

#include <kedittoolbar.h>
#include <qsplitter.h>
#include <kaction.h>
#include <kconfig.h>
#include <qmessagebox.h>
#include <qtoolbutton.h>

/**
 * Sets up default settings.
 * @param parent the parent widget
 * @param userName the name of the ownder of this widget.
 * @param roomName the name of the room.
 */
ChatRoom::ChatRoom(QString userName, QString roomName, QWidget *parent): Chat(userName,roomName,parent){
  resize(447,330);
  // mail_generic
  (void)new KAction(i18n("&Invite Buddy(s)..."), 0, this, SLOT(slotBuddyInvite()), actionCollection(), "contact_invite" );
  //
  (void)new KAction(i18n("&Save Size"), 0, this, SLOT(saveSize()), actionCollection(), "view_saveSize" );
  initChatWindow();

  createGUI("aimchatroomrc");
  updateChatSettings();

  control->owner = myName;
  setMinimumSize(350,200);


  // Set up the default size of the window.
  KConfig &config = *KGlobal::config();
  config.setGroup("Aim Chat Room Window Size");
  int x = config.readNumEntry("width", 447);
  int y = config.readNumEntry("height", 330);
  int s1 = config.readNumEntry("splitter1", 40);
  int s2 = config.readNumEntry("splitter2", 40);

  this->resize(x,y);
  
  QValueList<int> list;
  list = splitter->sizes();
  list[1] = s1;
  splitter->setSizes(list);

  QValueList<int> list2;
  list2 = vSplitter->sizes();
  list2[1] = s2;
  vSplitter->setSizes(list2);
}

/**
 * Bring up the Toolbar editor, set it with this windows buttons, if 
 * toolbar is changed re build them.
 */
void ChatRoom::options_configuretoolbars(){
  KEditToolbar dlg(actionCollection(), "aimchatroomrc");
  if(dlg.exec())
    createGUI("aimchatroomrc");
}

/**
 * Save the size of the window.
 */
void ChatRoom::saveSize(){
  QValueList<int> list;
  list = splitter->sizes();
  int s1 = list[1];

  QValueList<int> list2;
  list2 = vSplitter->sizes();
  int s2 = list2[1];

  KConfig &config = *KGlobal::config();
  config.setGroup("Aim Chat Room Window Size");
  config.writeEntry("width", this->width());
  config.writeEntry("height", this->height());
  config.writeEntry("splitter1", s1);
  config.writeEntry("splitter2", s2);
  QMessageBox::information(0, QString("Kinkatta - Message"), QString("Your sizes have been saved."));
}

/**
 * Sets up the input window and the chat window.
 */
void ChatRoom::initChatWindow(){
  vSplitter = new QSplitter(this, "Splitter" );
  vSplitter->setOrientation(QSplitter::Horizontal);
  splitter = new QSplitter(vSplitter, "Splitter" );
  control = new ChatRoomControlImp( vSplitter, "control" );
  connect(control, SIGNAL(getInfo(QString)), this, SIGNAL(getInfo(QString)));
  connect(control, SIGNAL(im(QString)), this, SIGNAL(im(QString)));

  Chat::initChatWindow();

  QValueList<int> list;
  list = vSplitter->sizes();
  list[1] = 40;
  vSplitter->setSizes(list);
  this->setCentralWidget( vSplitter );
}


/**
 * Parse the incoming message and set up the room to accept the incoming.
 * i.e. so we can block people.
 * @param buddy the person who is sending the message.
 * @param message the message 'buddy' is sending.
 */
void ChatRoom::messageInParse( QString buddyName, bool , QString message ){
  if (control->ignore(buddyName) == false){
    contactName = buddyName;
    if (myName != buddyName)
      messageIn(message);
  }
}

/**
 * A buddy left or joined the room, update the list
 * @param buddy the name of the buddy
 * @param curstat the status of 'buddy'
 */
void ChatRoom::updateBuddy(QString buddyName, bool newStatus){
  control->updateContact(buddyName, newStatus);
}

/**
 * The server just knocked you off.  Send such a message to the log.
 */
void ChatRoom::leftRoom(){
  contactName = "AOL Server";
  messageIn("YOU HAVE LEFT THE ROOM.\n");
}

/**
 * Bring up the buddy invite dialog. The reason this is done as a signal is to
 * allow for the entire list to be added to the invite widget.
 */
void ChatRoom::slotBuddyInvite(){
  emit showInviteWidget( contactName.toInt() );
}

// chatroom.cpp

