#include "kinkattalinkdialog.h"

#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/** 
 *  Constructs a KinkattaLinkDialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KinkattaLinkDialog::KinkattaLinkDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
	: KDialog( parent, name, modal, fl )
{
	if ( !name )
		setName( "KinkattaLinkDialog" );
	resize( 529, 140 );
	setCaption( tr( "Kinkatta - Insert Link"  ) );
	setSizeGripEnabled( FALSE );
	setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, sizePolicy().hasHeightForWidth() ) );
	setMinimumSize( QSize( 529, 140 ) );
	setFixedHeight( 140 );

	MainLayout = new QWidget( this, "MainLayout" );
	MainLayout->setGeometry( QRect( 10, 5, 510, 115 ) );
	vbox = new QVBoxLayout( MainLayout );
	vbox->setSpacing( 6 );
	vbox->setMargin( 0 );

	Frame3 = new QFrame( MainLayout, "Frame3" );
	Frame3->setFrameShadow( QFrame::Raised );
	Frame3->setFrameShape( QFrame::StyledPanel );
	grid = new QGridLayout( Frame3 );
	grid->setSpacing( 6 );
	grid->setMargin( 11 );

	grid_2 = new QGridLayout;
	grid_2->setSpacing( 6 );
	grid_2->setMargin( 0 );

	TextLabel1_2 = new QLabel( Frame3, "TextLabel1_2" );
	TextLabel1_2->setText( tr( "Description"  ) );

	grid_2->addWidget( TextLabel1_2, 1, 0 );

	TextLabel1 = new QLabel( Frame3, "TextLabel1" );
	TextLabel1->setText( tr( "URL"  ) );

	grid_2->addWidget( TextLabel1, 0, 0 );

	desc = new QLineEdit( Frame3, "desc" );

	grid_2->addWidget( desc, 1, 1 );

	url = new QLineEdit( Frame3, "url" );

	grid_2->addWidget( url, 0, 1 );

	grid->addLayout( grid_2, 0, 0 );
	vbox->addWidget( Frame3 );

	hbox = new QHBoxLayout;
	hbox->setSpacing( 6 );
	hbox->setMargin( 0 );
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	hbox->addItem( spacer );

	buttonOk = new QPushButton( MainLayout, "buttonOk" );
	buttonOk->setText( tr( "&Insert"  ) );
	buttonOk->setAutoDefault( TRUE );
	buttonOk->setDefault( TRUE );
	hbox->addWidget( buttonOk );

	buttonClear = new QPushButton( MainLayout, "buttonClear" );
	buttonClear->setText( tr( "Clear"  ) );
	buttonClear->setAutoDefault( TRUE );
	hbox->addWidget( buttonClear );

	buttonCancel = new QPushButton( MainLayout, "buttonCancel" );
	buttonCancel->setText( tr( "&Cancel"  ) );
	buttonCancel->setAutoDefault( TRUE );
	hbox->addWidget( buttonCancel );
	vbox->addLayout( hbox );

	setTabOrder(url, desc);
	setTabOrder(desc, buttonOk);
	setTabOrder(buttonOk, buttonClear);
	setTabOrder(buttonClear, buttonCancel);
	setTabOrder(buttonCancel, url);
	// signals and slots connections
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
	connect( buttonClear, SIGNAL( clicked() ), url, SLOT( clear() ) );
	connect( buttonClear, SIGNAL( clicked() ), desc, SLOT( clear() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}

/**
 * Sets the size of the object.
 */
void KinkattaLinkDialog::resizeEvent(QResizeEvent *){
  this->MainLayout->setGeometry(10, 5, this->width()-19, this->height()-15);
}

/**
 * Runs the widget.  Will return with a link if the user presses go otherwise
 * returns with a empty QString.
 */
QString KinkattaLinkDialog::go(){
  url->setFocus();
  url->selectAll();
  if( exec() ){ //pressed OK
    if( url->text().isEmpty() )
    return QString();
    if( desc->text().isEmpty() )
    return QString("<a href=\"" + url->text() + "\">" + url->text() + "</a>");
    //both URL and desc were given:
    return QString("<a href=\"" + url->text() + "\">" + desc->text() + "</a>");
  }
  else //pressed cancel
   return QString();
}

/**
 * Set the default url text.
 * @param s text to use.
 */
void KinkattaLinkDialog::setURLText( QString s ){
  url->setText(s);
}

/**
 * Set the default description text.
 * @param s text to use.
 */
void KinkattaLinkDialog::setDescText( QString s ){
  desc->setText(s);
}

