

#  Copyright Mission Critical Linux, 2000

#  Kimberlite is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 2, or (at your option) any
#  later version.

#  Kimberlite is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with Kimberlite; see the file COPYING.  If not, write to the
#  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
#  MA 02139, USA.
#
# $Revision: 1.5 $
#
# Author: Gregory P. Myrdal <Myrdal@MissionCriticalLinux.Com>
#
#------------------------------------------------------------

#
# KornShell library for user script functions.
#

#
#
#
startUser()
{
	typeset user_script
	typeset logfile=/tmp/UserScript.log
	typeset ret_val

	user_script=$(getSvcUserScript $DB $SVC_ID)
	ret_val=$?
	case $ret_val in
	  0) : ;;			# found it
	  2) return $SUCCESS ;;	# a user script does not exist
	  *) logAndPrint $LOG_ERR "\
Cannot find user script for service $SVC_NAME, err=$ret_val"
	    return $FAIL ;;
	esac

	if [ -z "$user_script" ]; then	# it must not exist
	  return $SUCCESS
	fi
	
	if [ ! -f $user_script ]; then
	  logAndPrint $LOG_ERR "\
User script '$user_script' is defined for service $SVC_NAME, but does not exist"
	  return $FAIL
	fi

	if [ ! -x $user_script ]; then
	  logAndPrint $LOG_WARNING "\
User script '$user_script' is not executable, turning execute bit on"
	  chmod +x $user_script
	fi

	logAndPrint $LOG_NOTICE "Running user script '$user_script start'"

	($user_script start $SVC_NAME > $logfile 2>&1)
	ret_val=$?
	if [ $ret_val -ne 0 ]; then
	  logAndPrint $LOG_ERR "\
User script '$user_script start $SVC_NAME' returned error $ret_val; logfile is $logfile"
	  return $FAIL
	fi

	rm -f $logfile		# everything went well, remove the logfile

	return $SUCCESS
}

#
#
#
stopUser()
{
	typeset user_script
	typeset logfile=/tmp/UserScript.log
	typeset ret_val

	user_script=$(getSvcUserScript $DB $SVC_ID)
	ret_val=$?
	case $ret_val in
	  0) : ;;			# found it
	  2) return $SUCCESS ;;	# a user script does not exist
	  *) logAndPrint $LOG_ERR "\
Cannot find user script for service $SVC_NAME, err=$ret_val"
	    return $FAIL ;;
	esac

	if [ -z "$user_script" ]; then	# it must not exist
	  return $SUCCESS
	fi
	
	#
	# Log only a warning if the stop script does not exist.  The
	# stop script may be on the shared device, thus, will not be
	# there during service stops at boot time.
	#
	if [ ! -f $user_script ]; then
	  logAndPrint $LOG_WARNING "\
User script '$user_script' is defined for service $SVC_NAME, but does not exist"
	  return $SUCCESS
	fi

	if [ ! -x $user_script ]; then
	  logAndPrint $LOG_WARNING "\
User script '$user_script' is not executable, turning execute bit on"
	  chmod +x $user_script
	fi

	logAndPrint $LOG_NOTICE "Running user script '$user_script stop'"

	($user_script stop $SVC_NAME > $logfile 2>&1) 
	ret_val=$?
	if [ $ret_val -ne 0 ]; then
	  logAndPrint $LOG_ERR "\
User script '$user_script stop $SVC_NAME' returned error $ret_val; logfile is $logfile"
	  return $FAIL
	fi

	rm -f $logfile		# everything went well, remove the logfile

	return $SUCCESS
}
