#!/usr/bin/ksh

#  Copyright Mission Critical Linux, 2000

#  Kimberlite is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 2, or (at your option) any
#  later version.

#  Kimberlite is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with Kimberlite; see the file COPYING.  If not, write to the
#  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
#  MA 02139, USA.
#
# $Revision: 1.1 $
#
# Author: Gregory P. Myrdal <Myrdal@MissionCriticalLinux.Com>
#
# This is a front end stub to lockInit() for the Service Manager to
# call to initialize shell based locks before the cluster starts.
#
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
# Global variables
#---------------------------------------------------------------------------

export PATH=/usr/sbin:/sbin:/bin:/usr/sbin:/usr/bin:$PATH

MYNAME=$(basename $0)
KSH_LIB=$(dirname $0)/../ksh_lib

LIBRARIES="\
	$KSH_LIB/globals.ksh \
	$KSH_LIB/log.ksh \
	$KSH_LIB/svcdb.ksh \
	$KSH_LIB/lock.ksh \
"

for library in $LIBRARIES
do
	if [ -f $library ]; then
	  . $library
	else
	  logAndPrint $LOG_ERR "$MYNAME Error: Cannot find $library" | tee > /dev/console
	  return $FAIL
	fi
done

#---------------------------------------------------------------------------
# Main
#---------------------------------------------------------------------------

lockInit
exit $?
