# Displays help for the specified cluadmin command
# Author: Ron Lawrence (lawrence@missioncriticallinux.com)
# $Revision: 1.44 $
#

#  Copyright Mission Critical Linux, 2000

#  Kimberlite is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 2, or (at your option) any
#  later version.

#  Kimberlite is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with Kimberlite; see the file COPYING.  If not, write to the
#  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
#  MA 02139, USA.

namespace eval Help {
    variable helpdata

    array set helpdata {
        help
        "
The cluadmin utility provides a command-line user interface that
enables you to monitor and manage cluster systems and services.  See
cluadmin.8 for more information.\n\

You can obtain help by entering help and one of the following commands:\n\

cluster  service  apropos  clear  help  exit
"
        
        apropos
        "
Displays the cluadmin commands that match the specified character string 
argument or, if no argument is specified, displays all the cluadmin commands.\n\

For example: apropos service"

        exit
        {
Exits from cluadmin.}
        
        clear
        {
Clears the screen.}
        
        cluster
        "
Cluster related commands:\n\
            
status  monitor  loglevel  reload  name  edit
backup  restore  saveas restorefrom"

        cluster.reload 
        {
Forces the cluster daemons to re-read the cluster configuration database.}

        cluster.name
        "
Sets the name of the cluster to the specified name.  The cluster name is 
included is the output of the clustat cluster monitoring command.\n\ 

For example: cluster name nfscluster"

        cluster.loglevel
        "
Sets the logging for the specified cluster daemon to the specified severity 
level.  The default logging severity level is warning and higher.  You can 
customize logging for the following cluster daemons:\n\ 

  quorumd
  svcmgr
  powerd
  hb\n\
           
Specify the severity level or the numeric value associated with the level.  
The values 0 to 7 refer to the following severity levels:\n\  

  0 - emerg
  1 - alert
  2 - crit
  3 - err
  4 - warning
  5 - notice
  6 - info 
  7 - debug\n\
           
For example: cluster loglevel quorumd 7"

        cluster.status
        {
Displays a snapshot of the current cluster status.}

        cluster.monitor
        "
Continuously displays snapshots of the cluster status at five-second 
intervals.\n\

Press the Return or Enter key to stop the display.\n\  

You can specify the -interval option with a numeric argument to display 
snapshots at the specified time interval, in seconds.\n\  

In addition, you can specify the -clear option with a yes argument to 
clear the screen after each snapshot display or with a no argment to 
not clear the screen.\n\

For example: cluster monitor -clear yes -interval 10"

        cluster.backup 
        {
Saves a copy of the cluster configuration database in 
the /etc/opt/cluster/cluster.conf.bak file.}

        cluster.restore
        {
Restores the cluster configuration database from the backup copy in 
the /etc/opt/cluster/cluster.conf.bak file.}

        cluster.saveas
        "
Saves the cluster configuration database to the specified file.\n\

For example: cluster saveas /etc/cluster_backup.conf"

        cluster.restorefrom 
        "
Restores the cluster configuration database from the specified file.\n\
           
For example: cluster restorefrom /etc/cluster_backup.conf"

        cluster.edit
        "
Edits the cluster configuration database or the specified file
by using the editor specified by the EDITOR environment variable, 
or vi. \n\

Note that manually modifying the cluster database is not recommended.\n\

For example: cluster edit /etc/cluster_backup.conf"

        service
        "
Service related commands:\n\
            
add show modify disable enable delete "

        service.add
        "
Adds a cluster service to the cluster database.  The command prompts you 
for information about service resources and properties:\n\

   o Service name\n\
           
   o Whether you want to start the service after you add it or keep it disabled\n\
           
   o IP address or addresses for the service\n\
           
   o Disk partitions used in the service and access permissions\n\
           
   o Mount points and mount options for the disk partitions\n\
           
   o Location of any script used to start and stop the service\n\
           
   o System on which you prefer the service to run\n\
           
   o Whether you want the service to relocate to its preferred system when it 
     joins the cluster\n\


Enter a question mark \(?\) at a prompt to obtain help.\n\  

Enter a colon \(:\) and a single-character command at a prompt to  
do one of the following: \n\

c - Cancel and return to the top-level cluadmin command 
r - Restart to the initial prompt while keeping previous responses 
p - Proceed with the next prompt\n\

"

        service.disable
        "
Disables the specified running service.  A disabled service is still 
configured on a cluster system, but it is no longer running.  You must 
enable a disabled service to restart it.\n\

For example: service disable serviceName"

        service.enable
        "
Enables the specified disabled service and restarts it.\n\ 

For example: service enable servicename."

        service.show
        "
Service status related commands:\n\

state  config  services"

        service.show.state
        "
Displays the current status of the specified service.\n\
 
For example: service show state serviceName"

        service.show.config
        "
Displays the current configuration for the specified service.\n\

For example: service show config serviceName"

        service.show.services
        "
Displays services that are currently defined."

        service.modify
        "
Modifies the resources or properties of an existing service.\n\  

For example: service modify serviceName\n\

You can modify any of the information that you specified when the service 
was created:\n\

   o Service name\n\
           
   o Whether you want to start the service or keep it disabled\n\
           
   o IP address or addresses for the service\n\
           
   o Disk partitions used in the service and access permissions\n\
           
   o Mount points and mount options for the disk partitions\n\
           
   o Location of any script used to start and stop the service\n\
           
   o System on which you prefer the service to run\n\
           
   o Whether you want the service to relocate to its preferred system when it 
     joins the cluster\n\

After you enter the new service information, the service is stopped and the 
changes are included in the cluster database.  You can then enable the 
modified service or keep it disabled.\n\

Enter a question mark \(?\) at a prompt to obtain help.\n\  

Enter a colon \(:\) and a single-character command at a prompt to 
do one of the following: \n\

c - Cancel and return to the top-level cluadmin command 
r - Restart to the initial prompt while keeping previous responses 
p - Proceed with the next prompt\n\

"

        service.delete
        "
Deletes the specified service.\n\

For example: service delete serviceName"
    }

}

namespace eval prompter {
    set modlist {
        # Each entry consists of:
        #    { n {token multilplicity 
        #        validate_command 
        #        promptstr
        #        helpstr
        #        default_command
        #        { sublist }
        #    }}
        name {1
            {regexp {[A-Za-z0-9_]+} %v}
            {Service name (required)}
            {Enter a unique name for the service.  This field is required.}
            {identity ${::Service::V::serviceID}}

        }
        preferredNode {1
            {expr {[string match "none" [string tolower %v]] || \
                       [svc::ckPreferredNodeName [Service::_map_member_id_to_name %v]]}}
            {Preferred member}
            {Choose the preferred member for the service.}
            {set __def [::svc::getPreferredNodeName ${::Service::V::serviceID}] ; if { [notNULL $__def] } { identity $__def } else { identity None }}
        }
        relocateOnPreferredNodeBoot {1
            {expr {[regexp {^([Yy](es)?|[Nn](o)?)$} %v] || [svc::ckRelocateOnPreferredNodeBoot %v]}}
            {Relocate when the preferred member joins the cluster [yesnoprompt]}
            {Enables the service to automatically relocate to its preferred 
                member when it joins the cluster.}
            {any [::svc::getRelocateOnPreferredNodeBoot ${::Service::V::serviceID}] no}
        }
        userScript {1
            {svc::ckScript %v}
            {User script (e.g., /usr/foo/script or None)}
            {Enter the full path name for the script that starts the service.}
            {set __def [::svc::getScript ${::Service::V::serviceID}] ; if { [notNULL $__def] } { identity $__def } else { identity None }}
        }
        network.ipAddress {n
            {expr {[regexp {^[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?$} %v] && [svc::ckIPaddress %v]}}
            {IP address}
            {Enter an IP address for the service.  IP addresses must be 
                specified in dotted quad format.}
            {::svc::getIPaddress ${::Service::V::serviceID} ${::Service::V::netID}}
        }
        network.netmask {1
            {svc::ckNetmask %v}
            {Netmask (e.g. 255.255.255.0 or None)}
            {Specify a netmask for the interface. If none, 
                cluadmin will find the netmask for you.}
            {set __def [::svc::getNetmask ${::Service::V::serviceID} ${::Service::V::netID}] ; if { [notNULL $__def] } { identity $__def } else { identity None }}
        }
        network.broadcast {1
            {svc::ckBroadcast %v}
            {Broadcast (e.g. X.Y.Z.255 or None)}
            {Specify a broadcast address for the interface.  If none
                cluadmin will find the broadcast address for you.}
            {set __def [::svc::getBroadcast ${::Service::V::serviceID} ${::Service::V::netID}] ; if { [notNULL $__def] } { identity $__def } else { identity None }}
        }
        device.name {n
            {svc::ckDevice %v}
            {Device special file (e.g., /dev/sda1)}
            {Enter a device special file for the service.}
            __not_set__
        }
        device.mount_point {1
            {svc::ckMountPoint %v}
            {Mount point (e.g., /usr/mnt/service1)}
            {Specify a mount point for the device. If you are using 
                a raw device, enter "None."}
            {set __def [::svc::getMountPoint ${::Service::V::serviceID} ${::Service::V::deviceID}]; if { [notNULL $__def] } { identity $__def } else { identity None }}
        }
        device.mount_fstype {"?device%n.mount_fstype"
            {expr {[regexp {^[Nn][Oo][Nn][Ee]$} %v] || [svc::ckMountFstype %v]}}
            {Filesystem type (e.g., ext2, reiserfs, ext3 or None)}
            {Specify the type of filesystem on this device.  The list of 
                valid filesystems for this installation can be found by
                reading /proc/filesystems.  Leave this blank for the default
                filesystem mount behavior. It may be important to specify
                the explicit filesystem type for log based filesystems so
                that the fsck step is skipped when mounting the filesystem.}
            {::svc::getMountFstype ${::Service::V::serviceID} ${::Service::V::deviceID}}
        }
        device.mount_options {"?device%n.mount_point"
            {svc::ckMountOptions %v}
            {Mount options (e.g., rw,nosuid)}
            {Specify options for the mount point.  See the mount.8
                manpage for an explanation of mount options.

                Options may be zero or more of the following options, separated by commas:
                rw, ro, suid, dev, nodev, exec, noexec, 
                sync, async, atime, noatime, auto, noauto, 
                nosuid, user, nouser, remount, default, 
                bsddf, minixdf, check, check=none, check=nocheck, 
                check=normal, check=strict, debug, errors=continue, 
                errors=remount-ro, errors=panic, grpid, bsdgroups, 
                nogrpid, sysvgroups, resgid=n, resuid=n, sb=n, 
                grpquota, noquota, quota, usrquota,
            }
            {::svc::getMountOptions ${::Service::V::serviceID} ${::Service::V::deviceID}}
        }
        device.force_unmount {"?device%n.mount_point"
            {expr {[regexp {^([Yy](es)?|[Nn]o?)$} %v] || [svc::ckForceUnmount %v]}}
            {Forced unmount support [yesnoprompt]}
            {Allows the device to be unmounted even if the device is busy.}
            {any [::svc::getForceUnmount ${::Service::V::serviceID} ${::Service::V::deviceID}] no}
        }
        device.device_owner {1
            {expr {[regexp {^$} %v] || [svc::ckDeviceOwner %v]}}
            {Device owner (e.g., root)}
            {Enter the owner of the device.}
            {::svc::getDeviceOwner ${::Service::V::serviceID} ${::Service::V::deviceID}}
        }
        device.device_group {1
            {expr {[regexp {^$} %v] || [svc::ckDeviceGroup %v]}}
            {Device group (e.g., root)}
            {Enter the group to which the device belongs.}
            {::svc::getDeviceGroup ${::Service::V::serviceID} ${::Service::V::deviceID}}
        }
        device.device_mode {1
            {svc::ckDeviceMode %v}
            {Device mode (e.g., 755)}
            {Enter the permissions for the device.}
            {::svc::getDeviceMode ${::Service::V::serviceID} ${::Service::V::deviceID}}
        }
        device.exports.directory.name {1
            {svc::ckExportDir %v}
            {Export directory name}
            {Enter the name of a directory to export.}
            {identity __not_set__}
        }
        device.exports.directory.client.name {1
            {svc::ckExportClient %v}
            {export client name}
            {Enter the name of a client for this directory.  
             Leave  the entry blank for an export to all clients.}
            {identity __not_set__}
        }
        device.exports.directory.client.options {1
            {svc::ckExportOptions %v}
            {export client options}
            {Enter export options for this client.
                See the exports.5 manpage for an explanation of export options.

                Options may be zero or more of the following options, 
                separated by commas:

                Red Hat Linux:
                secure, insecure, ro, rw, noaccess, 
                link_relative, link_absolute, 
                root_squash, no_root_squash, 
                squash_uids, squash_gids, all_squash, 
                no_all_squash, map_daemon, 
                map_static, map_nis, anonuid=, anongid=, 
                
                Turbo Linux:
                secure, insecure, rw, ro, sync, async, 
                no_wdelay, wdelay, nohide, hide, 
                no_subtree_check, subtree_check, root_squash, 
                no_root_squash, all_squash, no_all_squash, 
                anonuid=, anongid=, 

                other Linux' extra options:
                insecure_locks, no_auth_nlm 
            }
            {identity None}
        }
        device.exports.directory.client.options.all {1
            {svc::ckExportOptions %v}
            {export to all options}
            {enter export options for export to all.}
            {identity None}
        }
        disabled {1
            {expr {[regexp {^([Yy](es)?|[Nn]o?)$} %v] || [svc::ckDisabled %v]}}
            {Disable service [yesnoprompt]}
            {Allows you to keep the service disabled, until you enable it.}
            {any [::svc::getDisabled ${::Service::V::serviceID}] no}
        }
    }
    array set prompts {
        initial_prompt "
            \[exec date\]\n
            You can obtain help by entering help and one of the following commands:\n
            \[string trim \$commands\]\n
\n\
        "
        base_prompt {cluadmin> }
            
        failedToLoad {
            Failed to load cluster.so.
            Adjust LD_LIBRARY_PATH to point to it.
        }
        seizeTheLock {
            Seize the lock? [yesnoprompt]
        }
        seizeTheLockHelp {
            Another process has claimed the advisory lock on the cluster
            database.  If you take the lock, you may be overwriting changes
            that have already been entered in the cluster configuration database.  
            Enter \"Y\" to forcefully take the lock.
        }
        proceedWithoutLock
        {
            Proceed without the lock? [yesnoprompt] 
        }
        proceedWithoutLockHelp {
            You can proceed without the lock, but you will have only read 
            access to cluster information.  
            Enter \"Y\" to proceed without the lock.
        }
        navigationCommands {
            c\)ancel r\)estart p\)roceed: 
        }
        navigationCommandsHelp "
            Colon commands:\n\
 
            c - Cancels and returns to the top-level cluadmin command 
            r - Restarts to the initial prompt while keeping previous responses 
            p - Proceeds with the next prompt\n\
 
            Enter a colon and the single-character command.
        "
        serviceModifyPrompt1 "
            You will be prompted for information about the service.\n\

            Enter a question mark (?) at a prompt to obtain help.\n\

            Enter a colon \(:\) and a single-character command at a prompt to do
            one of the following:\n\ 

            c - Cancel and return to the top-level cluadmin command 
            r - Restart to the initial prompt while keeping previous responses 
            p - Proceed with the next prompt\n\
 
            
        "
        serviceModifyConfirm {
            Commit the above changes to service $service [yesnoprompt]
        }
        serviceModifyConfirmHelp "
            All entries for this service have been completed.  \nAnswer \"Y\" \
            to submit the changes, answer \"N\" to cancel the changes.
        "
        serviceAddPrompt1 "\n\
            The user interface will prompt you for information about the service.\n\
            Not all information is required for all services.\n\
            
            Enter a question mark \(?\) at a prompt to obtain help.\n\

            Enter a colon \(:\) and a single-character command at a prompt to do 
            one of the following:\n\

            c - Cancel and return to the top-level cluadmin command 
            r - Restart to the initial prompt while keeping previous responses 
            p - Proceed with the next prompt\n\
 
            
        "
        serviceAddConfirm {Add $service service as shown? [yesnoprompt] }
        serviceAddConfirmHelp "
            All entries for this service have been completed.  \nEnter \"Y\" to
            submit the changes.  Enter \"N\" to cancel the changes.
        "
        editDiscouragement {
            Direct editing of the cluster configuration data through this interface
            is not recommended, because it can cause unpredictable results. 
            Do it anyway? [yesnoprompt]
        }
        lostTheLock {
            The session lock has been removed.
            The cluster database may have changed.
            You must exit cluadmin before you will be able to make any changes.
        }
        restartAfterModify {
            Restart the service?
        }
        restartAfterModifyHelp {
            Service was disabled prior to modification, but was not modified.
            Answer "Y" to restart the service, "N" to leave it disabled.
        }
    }
}
