/* $Id: parser.c,v 1.21 2008/03/23 21:09:36 ekalin Exp $ */

/*
 * Copyright (C) 2004-2008 Eduardo M Kalinowski <ekalin@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <locale.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

/* Perl includes */
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/
static int  find_next_command_separator(World *world, const char *cmdline);
static void process_aliases(World      *world,
                            const char *cmdline,
                            int         start,
                            int         end);
static void process_command(World *world, const char *cmd, int len);



void
parse_commands(World *world, const char *cmdline, int totallen)
{
  int      seppos;
  int      start;
  int      end;
  gboolean quit;
  int      cmdseplen;

  cmdseplen = strlen(world->command_separator);

  start = 0;
  quit = FALSE;
  do {
    seppos = find_next_command_separator(world, cmdline + start);
    if (seppos == -1) {
      end = totallen;
      quit = TRUE;
    } else {
      seppos += start;
      end = seppos;
      while (cmdline[end-1] == ' ')
        --end;
    }
    if (start != 0)
      while (cmdline[start] == ' ')
        ++start;

    process_aliases(world, cmdline, start, end);
    start = seppos + cmdseplen;
  } while (!quit);
}


static
int
find_next_command_separator(World *world, const char *cmdline)
{
  int  pos       = 0;
  int  len       = strlen(cmdline);
  char quote     = 0;
  int  cmdseplen = strlen(world->command_separator);

  while (pos < len) {
    if (cmdline[pos] == '\"' || cmdline[pos] == '\'') {
      if (quote && cmdline[pos] == quote) {
        if (cmdline[pos-1] != '\\') {
          quote = 0;
        }
      } else {
        if (pos == 0 || cmdline[pos-1] != '\\') {
          quote = cmdline[pos];
        }
      }

    } else if (cmdline[pos] == world->command_separator[0]) {
      if (!quote && pos != (len - (cmdseplen-1))
          && strncmp(cmdline + pos, world->command_separator,
                     cmdseplen) == 0) {
        return pos;
      }
    }

    ++pos;
  }

  return -1;
}


static
void
process_aliases(World *world, const char *cmdline, int start, int end)
{
  char  cmd[MAX_BUFFER + 1];
  int   len = end - start;
  char *result;

  if (len >= MAX_BUFFER) {
    ansitextview_append_string_nl(world->gui,
                                  _("Warning: Trying to send a very long command line. Perhaps a recursive alias definition?"));
    process_command(world, cmdline + start, len);
    return;
  }

  memcpy(cmd, cmdline + start, len);
  cmd[len] = '\0';

  result = substitute_aliases(world, cmd);
  if (result) {
    parse_commands(world, result, strlen(result));
    g_free(result);
  } else {
    process_command(world, cmd, len);
  }
}


static
void
process_command(World *world, const char *cmd, int len)
{
  if (*cmd != '/') {
    send_to_world(world, cmd, len);
  } else {
    if (*(cmd + 1) == '/') {
      send_to_world(world, cmd + 1, len - 1);
    } else {
      SV *commands;
      SV *error;

      PERL_SET_CONTEXT(world->perl_interpreter);
      commands = newSVpv(cmd + 1, len - 1);
      eval_sv(commands, TRUE | G_EVAL);
      error = get_sv("@", TRUE);
      if (SvTRUE(error)) {
        ansitextview_append_stringf(world->gui,
                                    "Perl Error: %s", SvPV_nolen(error));
      }
    }
  }
}
